% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mexico_cpi.R
\name{get_mexico_cpi}
\alias{get_mexico_cpi}
\title{Get Mexico's Consumer Price Index (2010 = 100) from World Bank}
\usage{
get_mexico_cpi()
}
\value{
A tibble with four columns:
\describe{
  \item{indicator}{Indicator name (e.g., "Consumer price index (2010 = 100)")}
  \item{country}{Country name ("Mexico")}
  \item{year}{Year of the data (integer)}
  \item{value}{Consumer Price Index value (numeric)}
}
}
\description{
Retrieves Mexico's Consumer Price Index (CPI) using 2010 as the base year,
for the years 2010 to 2022 from the World Bank Open Data API.
The indicator used is `FP.CPI.TOTL`.
}
\details{
The function sends a GET request to the World Bank API.
If the API request fails or returns an error status code, the function returns `NULL` with an informative message.
}
\note{
Requires internet connection. Data is retrieved in real time from the World Bank API.
}
\examples{
if (interactive()) {
  get_mexico_cpi()
}

}
\seealso{
\code{\link[httr]{GET}}, \code{\link[jsonlite]{fromJSON}}, \code{\link[dplyr]{as_tibble}}
}
