% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3-1.layout.R
\name{c_net_layout}
\alias{c_net_layout}
\alias{c_net_lay}
\title{Layout coordinates}
\usage{
c_net_layout(
  go,
  method = igraph::nicely(),
  order_by = NULL,
  order_ls = NULL,
  seed = 1234,
  line_curved = 0.5,
  rescale = TRUE,
  ...
)
}
\arguments{
\item{go}{igraph or metanet}

\item{method}{(1) as_line(), as_arc(), as_polygon(), as_polyarc(), as_polycircle(), as_circle_tree();
(2) as_star(), as_tree(), in_circle(), nicely(), on_grid(), on_sphere(),randomly(), with_dh(), with_fr(), with_gem(), with_graphopt(), with_kk(),with_lgl(), with_mds(),. see \code{\link[igraph]{layout_}};
(3) a character, "auto","backbone","centrality","circlepack","dendrogram",
"eigen","focus","hive","igraph","linear","manual","matrix",
"partition","pmds","stress","treemap","unrooted". see \code{\link[ggraph]{create_layout}}}

\item{order_by}{order nodes according to a node attribute}

\item{order_ls}{manual the discrete variable with a vector, or continuous variable with "desc" to decreasing}

\item{seed}{random seed}

\item{line_curved}{consider line curved, only for some layout methods like as_line(), as_polygon().default:0}

\item{rescale}{logical, scale the X, Y to (-1,1)}

\item{...}{add}
}
\value{
coors object: coordinates for nodes, columns: name, X, Y; curved for edges, columns: from, to, curved;
}
\description{
Layout coordinates
}
\examples{
library(igraph)
c_net_layout(co_net) -> coors
c_net_plot(co_net, coors)
c_net_plot(co_net, c_net_layout(co_net, in_circle()), vertex.size = 2)
c_net_plot(co_net, c_net_layout(co_net, in_circle(), order_by = "v_class"), vertex.size = 2)
c_net_plot(co_net, c_net_layout(co_net, in_circle(), order_by = "size", order_ls = "desc"))
c_net_plot(co_net, c_net_layout(co_net, as_polygon(3)))
}
\seealso{
Other layout: 
\code{\link{as_arc}()},
\code{\link{as_circle_tree}()},
\code{\link{as_line}()},
\code{\link{as_multi_layer}()},
\code{\link{as_poly_sector}()},
\code{\link{as_polyarc}()},
\code{\link{as_polycircle}()},
\code{\link{as_polygon}()}
}
\concept{layout}
