% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BAM2OM.R
\name{BAM2MOM}
\alias{BAM2MOM}
\alias{BAM2OM}
\title{Import a multi-stock, multi-fleet OM from a BAM object}
\usage{
BAM2MOM(
  rdat,
  nsim = 48,
  proyears = 50,
  interval = 1,
  stock_name = NULL,
  fleet_name = NULL,
  LowerTri = 0,
  report = FALSE,
  ...
)

BAM2OM(rdat, nsim = 48, proyears = 50, interval = 2, report = FALSE, ...)
}
\arguments{
\item{rdat}{A list object from the \code{BAMextras} package. Use \code{bamExtras::standardize_rdat(rdat)}}

\item{nsim}{the number of simulations}

\item{proyears}{the number of projection years}

\item{interval}{the management interval}

\item{stock_name}{Name of the stock(s)}

\item{fleet_name}{Name of the fleet(s)}

\item{LowerTri}{Integer. The number of recent years for which model estimates of recruitment are ignored (not reliably estimated by the assessment)}

\item{report}{Logical, if TRUE, a diagnostic will be reported showing the matching of the OM reconstructed numbers at age vs the assessment.}

\item{...}{Additional arguments passed to \code{MSEtool::Assess2MOM}}
}
\value{
An object of class \code{MOM}
}
\description{
Import a multi-stock, multi-fleet OM from a BAM object
}
\section{Functions}{
\itemize{
\item \code{BAM2OM()}: Create a single stock/fleet OM from a BAM object

}}
