% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeLong.R, R/jackknife.R, R/unbiased.R
\name{cov_methods}
\alias{cov_methods}
\alias{DeLong}
\alias{jackknife}
\alias{unbiased}
\title{Covariance Methods}
\usage{
DeLong()

jackknife()

unbiased(abar = FALSE)
}
\arguments{
\item{abar}{logical indicating whether to compute mean covariance components.}
}
\value{
Returns a function of class \code{cov_method} specifying a covariance
method for \code{\link{mrmc}}, \code{\link{srmc}}, or \code{\link{stmc}}.
}
\description{
Reader performance metric covariance estimation methods to be used with
package-supplied multi-case statistical analysis functions.
}
\references{
DeLong ER, DeLong DM, and Clarke-Pearson DL (1988). Comparing the areas under
two or more correlated receiver operating characteristic curves: a
nonparametric approach. Biometrics, 44: 837–45.

Efron B (1982). The Jackknife, the Bootstrap and Other Resampling Plans.
Philadelphia: SIAM.

Gallas BD, Pennello GA, and Meyers KJ (2007). Multireader multicase variance
analysis for binary data. JJournal of the Optical Society of America A, 24:
B70–80.
}
\seealso{
\code{\link{mrmc}}, \code{\link{srmc}}, \code{\link{stmc}}
}
