% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_tuning_results}
\alias{plot_tuning_results}
\title{Plotting Tuner Search Results}
\usage{
plot_tuning_results(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
The \strong{plot_tuning_results()} function generates graphical representations of
hyperparameter search results, automatically adapting to the type of optimizer
used. When Bayesian optimization is employed, the function presents additional
plots showing the iterative evolution of the loss function and search results
throughout the optimization process. This function validates that model fitting
has been completed and that hyperparameter tuning was actually performed before
attempting to display results.
}
\examples{
# Note: For obtaining the plot with tuning results the user needs to complete till
# fine_tuning( ) function of the MLwrap pipeline.

# See the full pipeline example under table_best_hyperparameters()
# Final call signature:
# plot_tuning_results(wrap_object)

}
\seealso{
\code{\link{table_best_hyperparameters}}
}
