% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_utils.R
\name{table_integrated_gradients_results}
\alias{table_integrated_gradients_results}
\title{Integrated Gradients Summarized Results Table}
\usage{
table_integrated_gradients_results(analysis_object, show_table = FALSE)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'sensitivity_analysis(methods = "Integrated Gradients")'.}

\item{show_table}{Boolean. Whether to show the table.}
}
\value{
Tibble or list of tibbles (multiclass classification) with Integrated Gradient summarized results.
}
\description{
The \strong{table_integrated_gradients_results()} function implements the same summarized metrics scheme for
Integrated Gradients values, a methodology specifically designed for neural networks that calculates
feature importance through gradient integration along paths from a baseline to the current input. To
summarize the Integrated Gradients values calculated, three different metrics are computed:
\itemize{
\item \strong{Mean Absolute Value}
\item \strong{Standard Deviation of Mean Absolute Value}
\item \strong{Directional Sensitivity Value} (Cov(Feature values, IG values) / Var(Feature values))
}
}
\examples{
# Note: For obtaining the table with Integrated Gradients method results
# the user needs to complete till sensitivity_analysis() function of the
# MLwrap pipeline using the Integrated Gradient method.

if (requireNamespace("torch", quietly = TRUE)) {

  \donttest{

  wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
  wrap_object <- build_model(wrap_object, "Neural Network")
  wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")
  wrap_object <- sensitivity_analysis(wrap_object, methods = "Integrated Gradients")

  # And then, you can obtain the Integrated Gradients results table.

  table_IG <- table_integrated_gradients_results(wrap_object)

  }

}

}
