% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_DRAC.R
\name{use_DRAC}
\alias{use_DRAC}
\title{Use DRAC to calculate dose rate data}
\usage{
use_DRAC(file, name, print_references = TRUE, citation_style = "text", ...)
}
\arguments{
\item{file}{\link{character} (\strong{required}):
name of a CSV file (formatted according to the DRAC v1.2 CSV template) to
be sent to the DRAC website for calculation. It can also be a DRAC template
object obtained from \code{\link[=template_DRAC]{template_DRAC()}}, which supports also import from
CSV-files.}

\item{name}{\link{character} (\emph{with default}):
Optional user name submitted to DRAC. If omitted, a random name will be generated}

\item{print_references}{(\emph{with default}):
Print all references used in the input data table to the console.}

\item{citation_style}{(\emph{with default}):
If \code{print_references = TRUE} this argument determines the output style of the
used references. Valid options are \code{"Bibtex"}, \code{"citation"}, \code{"html"}, \code{"latex"}
or \code{"R"}. Default is \code{"text"}.}

\item{...}{further arguments:
\itemize{
\item \code{url} \link{character}: provide an alternative URL to DRAC
\item \code{ignore_version} \link{logical}: ignores the version check, this might come in handy
if the version has changed, but not the column order
\item \code{user} \link{character}: option to provide username for secured site
\item \code{password} \link{character}: password for secured site, only works jointly with \code{user}
\item \code{verbose} \link{logical}: show or hide console output
}}
}
\value{
Returns an \linkS4class{RLum.Results} object containing the following elements:

\item{DRAC}{\link{list}: a named list containing the following elements in slot \verb{@data}:

\tabular{lll}{
\verb{$highlights} \tab \link{data.frame} \tab summary of 25 most important input/output fields \cr
\verb{$header} \tab \link{character} \tab HTTP header from the DRAC server response \cr
\verb{$labels} \tab \link{data.frame} \tab descriptive headers of all input/output fields \cr
\verb{$content} \tab \link{data.frame} \tab complete DRAC input/output table \cr
\verb{$input} \tab \link{data.frame} \tab DRAC input table \cr
\verb{$output} \tab \link{data.frame} \tab DRAC output table \cr
\code{references}\tab \link{list} \tab A list of bib entries of used references \cr
}

}
\item{data}{\link{character} or \link{list} path to the input spreadsheet or a DRAC template}
\item{call}{\link{call} the function call}
\item{args}{\link{list} used arguments}

The output should be accessed using the function \link{get_RLum}.
}
\description{
The function provides an interface from R to DRAC. An R-object or a
CSV file is passed to the DRAC website and results are re-imported into R.
}
\section{Function version}{
 0.16
}

\examples{

## (1) Method using the DRAC spreadsheet

file <-  "/PATH/TO/DRAC_Input_Template.csv"

# send the actual IO template spreadsheet to DRAC
\dontrun{
use_DRAC(file = file)
}

## (2) Method using an R template object
# Create a template
input <- template_DRAC(preset = "DRAC-example_quartz")

# Fill the template with values
input$`Project ID` <- "DRAC-Example"
input$`Sample ID` <- "Quartz"
input$`Conversion factors` <- "AdamiecAitken1998"
input$`External U (ppm)` <- 3.4
input$`errExternal U (ppm)` <- 0.51
input$`External Th (ppm)` <- 14.47
input$`errExternal Th (ppm)` <- 1.69
input$`External K (\%)` <- 1.2
input$`errExternal K (\%)` <- 0.14
input$`Calculate external Rb from K conc?` <- "N"
input$`Calculate internal Rb from K conc?` <- "N"
input$`Scale gammadoserate at shallow depths?` <- "N"
input$`Grain size min (microns)` <- 90
input$`Grain size max (microns)` <- 125
input$`Water content ((wet weight - dry weight)/dry weight) \%` <- 5
input$`errWater content \%` <- 2
input$`Depth (m)` <- 2.2
input$`errDepth (m)` <- 0.22
input$`Overburden density (g cm-3)` <- 1.8
input$`errOverburden density (g cm-3)` <- 0.1
input$`Latitude (decimal degrees)` <- 30.0000
input$`Longitude (decimal degrees)` <- 70.0000
input$`Altitude (m)` <- 150
input$`De (Gy)` <- 20
input$`errDe (Gy)` <- 0.2

# use DRAC
\dontrun{
output <- use_DRAC(input)

## export as LaTeX table
.as.latex.table(output)
}

} 

\section{How to cite}{
Kreutzer, S., Dietze, M., Burow, C., 2025. use_DRAC(): Use DRAC to calculate dose rate data. Function version 0.16. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\references{
Durcan, J.A., King, G.E., Duller, G.A.T., 2015. DRAC: Dose Rate and Age Calculator for trapped charge dating.
Quaternary Geochronology 28, 54-61. doi:10.1016/j.quageo.2015.03.012
}
\seealso{
\link{template_DRAC}, \link{.as.latex.table}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)\cr
Michael Dietze, GFZ Potsdam (Germany)\cr
Christoph Burow, University of Cologne (Germany)
, RLum Developer Team}
