% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-generics.R
\name{melt_RLum}
\alias{melt_RLum}
\alias{melt_RLum,list-method}
\title{Melt RLum-class objects into a flat data.frame}
\usage{
melt_RLum(object, ...)

\S4method{melt_RLum}{list}(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}}

\item{...}{further arguments passed to the specific class method}
}
\value{
A flat \link{data.frame}.
}
\description{
Melt RLum-class objects into a flat data.frame
}
\section{Functions}{
\itemize{
\item \code{melt_RLum(list)}: Returns a list a single \link{data.frame}

}}
\section{Function version}{
 0.1.0
}

\examples{
data(ExampleData.XSYG, envir = environment())
melt_RLum(OSL.SARMeasurement[[2]][[1]])

}
\seealso{
\linkS4class{RLum.Data.Curve}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. melt_RLum(): Melt RLum-class objects into a flat data.frame. Function version 0.1.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\keyword{utilities}
