#' Internal Logic Forest Functions
#'
#' INTERNAL FUNCTION TO EVALUATE IMPORTANCE OF PREDICTOR COMBINATIONS
#' @param object An object of class \code{"logreg"}
#' @param msz Max number of leaves on a tree
#' @param ntr Number of trees in object
#' @param newbin matrix containing new datapoints for prediction
#' @param newsep new number of separate predictors
#' @param newcens censoring indicator
#'
#' @returns outframe
#' @export
#' @keywords internal

predict.logreg2 <- function(object, msz, ntr, newbin, newsep, newcens, ...)
{
  if(class(object)[1] != "logreg") 
    stop("object not of class logreg")
  if(object$choice > 2 && object$choice !=6) 
    stop("object$choice needs to be 1, 2, or 6")
  if(!missing(newbin)) {
    if((missing(newcens) == FALSE) && (missing(newbin) == FALSE)){
      y <- frame.logreg2(fit = object, newbin = newbin, newcens = newcens) #ADDING THIS 30MAR2025
    }
    if(missing(msz) && missing(ntr) && missing(newsep) && missing(newcens)) 
      y <- frame.logreg2(fit = object, newbin = newbin) #CHANGING THIS 30MAR2025
  }
  else {
    if(missing(msz) && missing(ntr))  
      y <- frame.logreg2(fit = object)[, -1]
    if(missing(msz) && (missing(ntr) == FALSE)) 
      y <- frame.logreg2(fit = object, ntr = ntr)[, -1]
    if((missing(msz) == FALSE) && missing(ntr)) 
      y <- frame.logreg2(fit = object, msz = msz)[, -1]
    if((missing(msz) == FALSE) && (missing(ntr) == FALSE)) 
      y <- frame.logreg2(fit = object, ntr = ntr, msz = msz)[, -1]
  }
  iik <- 0
  if(missing(msz) && missing(ntr) && object$select == "greedy") iik <- 1
  unstrip <- function(x) 
  {
    dd <- dim(x)
    y <- x
    if(length(dd) == 2) {
      dd2 <- dd[2]
      if(dd2 == 1) 
        y <- c(x[, 1])
      if(dd2 == 2) 
        y <- cbind(c(x[, 1]), c(x[, 2]))
      if(dd2 > 2) 
        y <- cbind(c(x[, 1]), c(x[, 2]), c(x[, 3]))
      if(dd2 > 3) 
        for(i in 4:dd2)
          y <- cbind(y, c(x[, i]))
      y
    }
    if(length(dd) == 1 || length(dd) == 0) {
      y <- c(unlist(c(unlist(x))))
      names(y) <- NULL
    }
    y
  }
  ly <- length(y[, 1])
  if(is.matrix(y) == FALSE) 
    y <- matrix(unstrip(y), nrow = ly)
  lly <- length(y[,1])
  y <- y[, -1]
  if(lly==1) y <- matrix(y, nrow=1)
  if(object$type == "proportional.hazards") 
    y <- y[, -1]
  z <- NULL
  if(length(y) == ly) 
    y <- matrix(y, ncol = 1)
  y <- cbind(y, rep(1, ly))
  if(object$select == "single.model") {
    z <- rep(object$model$coef[1], length(y[, 1]))
    for(i in 2:length(object$model$coef)) 
      z <- z + object$model$coef[i] * y[, i - 1]
  }
  if(object$type == "classification") 
    z[z != 0] <- 1
  if(object$type == "logistic") 
    z <- exp(z)/(1 + exp(z))
  z
}