% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{llm_api_key_env}
\alias{llm_api_key_env}
\title{Declare an API key sourced from an environment variable}
\usage{
llm_api_key_env(var, required = TRUE, default = NULL)
}
\arguments{
\item{var}{Name of the environment variable (e.g., "OPENAI_API_KEY").}

\item{required}{If TRUE, missing variables cause an authentication error at call time.}

\item{default}{Optional default if the environment variable is not set.}
}
\value{
An internal secret handle to be used as \code{api_key = llm_api_key_env("VARNAME")}.
}
\description{
Use this when creating an LLM config to avoid placing secrets
inside R objects. Store your key in your shell or in \verb{~/.Renviron}
and reference it here by name.
}
