% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OPC_LFM.R
\name{OPC_LFM}
\alias{OPC_LFM}
\title{Apply the OPC method to the Laplace factor model}
\usage{
OPC_LFM(data, m = m, A, D, p)
}
\arguments{
\item{data}{A matrix of input data.}

\item{m}{The number of principal components.}

\item{A}{The true factor loadings matrix.}

\item{D}{The true uniquenesses matrix.}

\item{p}{The number of variables.}
}
\value{
A list containing:
\item{Ao}{Estimated factor loadings.}
\item{Do}{Estimated uniquenesses.}
\item{MSEA}{Mean squared error for factor loadings.}
\item{MSED}{Mean squared error for uniquenesses.}
\item{tau}{The sparsity.}
}
\description{
This function computes Online Principal Component Analysis (OPC) for the provided input data, estimating factor loadings and uniquenesses. It calculates mean squared errors and sparsity for the estimated values compared to true values.
}
\examples{
library(SOPC)
library(LaplacesDemon)
library(MASS)
n=1000
p=10
m=5
mu=t(matrix(rep(runif(p,0,1000),n),p,n))
mu0=as.matrix(runif(m,0))
sigma0=diag(runif(m,1))
F=matrix(mvrnorm(n,mu0,sigma0),nrow=n)
A=matrix(runif(p*m,-1,1),nrow=p)
lanor <- rlaplace(n*p,0,1)
epsilon=matrix(lanor,nrow=n)
D=diag(t(epsilon)\%*\%epsilon)
data=mu+F\%*\%t(A)+epsilon
results <- OPC_LFM(data, m, A, D, p)
print(results)
}
