% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_iblm.R
\name{shap_to_onehot}
\alias{shap_to_onehot}
\title{Convert Shap values to Wide One-Hot Encoded Format}
\usage{
shap_to_onehot(shap, wide_input_frame, iblm_model)
}
\arguments{
\item{shap}{Data frame containing raw SHAP values from XGBoost.}

\item{wide_input_frame}{Wide format input data frame (one-hot encoded).}

\item{iblm_model}{Object of class 'iblm'}
}
\value{
A data frame where SHAP values are in wide format for categorical variables. Column "bias" is moved to start.
}
\description{
Transforms categorical variables in a data frame into one-hot encoded format. Renames "BIAS" to lowercase.
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

shap <- stats::predict(
  iblm_model$booster_model,
  newdata = xgboost::xgb.DMatrix(
    data.matrix(
      dplyr::select(df_list$test, -dplyr::all_of(iblm_model$response_var))
    )
  ),
  predcontrib = TRUE
) |> data.frame()

wide_input_frame <- data_to_onehot(df_list$test, iblm_model)

shap_wide <- shap_to_onehot(shap, wide_input_frame, iblm_model)

shap_wide |> dplyr::glimpse()

}
