% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{compute_calibration}
\alias{compute_calibration}
\title{Estimate calibration given forecasts and corresponding outcomes}
\usage{
compute_calibration(
  forecast,
  outcome,
  method = c("smoothing", "binning"),
  CI = NULL,
  binwidth = NULL,
  ...
)
}
\arguments{
\item{forecast}{Vector of probability forecasts.}

\item{outcome}{Vector of observations (0 or 1).}

\item{method}{Method used to estimate calibration, either "smoothing" or "binning".}

\item{CI}{Confidence level (e.g. 0.95). CI not computed if NULL (CI can be expensive to compute for LOWESS).}

\item{binwidth}{Binwidth when calibration is estimated by binning.
If NULL, automatic bin width selection with 'Sturges' method.}

\item{...}{Arguments of \code{\link[stats:loess]{stats::loess()}} function (e.g. span)}
}
\value{
Dataframe with columns \code{Forecast} (bins), \code{Frequency} (frequency of outcomes in the bin),
\code{Lower} (lower bound of the CI) and \code{Upper} (upper bound of the CI).
}
\description{
Estimate calibration given forecasts and corresponding outcomes
}
\examples{
N <- 1e4
f <- rbeta(N, 1, 1)
o <- sapply(f, function(x) {rbinom(1, 1, x)})
lapply(c("binning", "smoothing"),
       function(m) {
         cal <- compute_calibration(f, o, method = m)
         with(cal, plot(Forecast, Frequency, type = "l"))
         abline(c(0, 1), col = "red")
       })
}
