% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{ConnectivityDiff}
\alias{ConnectivityDiff}
\title{Connectivity difference between two conditions}
\usage{
ConnectivityDiff(wt, ko, prefix.wt, prefix.ko, resolution = 5000)
}
\arguments{
\item{wt}{hic2community result from condition 1}

\item{ko}{hic2community result from condition 2}

\item{prefix.wt}{Prefix for wt to be presented in the column names}

\item{prefix.ko}{Prefix for ko to be presented in the column names}

\item{resolution}{Resolution of Hi-C dataset}
}
\value{
A \code{list} of two \code{data.frame} objects, each representing the network connectivity differences of modules in condition 1 or condition 2 when compared to the counterpart cell type. Each \code{data.frame} contains the following columns: \code{"chr"}, \code{"module_start"}, \code{"module_end"}, \code{"connectivity"}, \code{"transitivity"}, \code{"centrality_node"}, \code{"idx"} (the row index of the module in the input module object), \code{"connectivity_in_(counterpart_cell_type)"}, \code{"connectivity_difference"}, and \code{"connectivity_foldchange"}.
}
\description{
output table of connectivity difference of modules between cell types is generated.
}
\details{
Connectivity difference between two conditions
}
\examples{
modulefile1 = system.file('extdata','mouse_naiveCD4T_Vahedi_short.rds',
package = 'HiCocietyExample')
modulefile2 = system.file('extdata','mouse_Th1_Vahedi_short.rds',
package = 'HiCocietyExample')
mycom1 = readRDS(modulefile1)
mycom2 = readRDS(modulefile2)
result = ConnectivityDiff(mycom1, mycom2, 'NaiveCD4T', 'Th1',
resolution = 5000)
head(print(result))
}
\author{
Sora Yoon, PhD
}
