% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtsmb.R
\encoding{UTF-8}
\name{gtsmb}
\alias{gtsmb}
\title{Generalized Two-Staged Model-Based estmation}
\usage{
gtsmb(y_S, X_S, X_Sa, Z_Sa, Z_U, Omega_S, Phis_Sa)
}
\arguments{
\item{y_S}{Response object that can be coersed into a column vector. The
\code{_S} denotes that \code{y} is part of the sample \emph{S}, with
\eqn{N_S \le N_{Sa} \le N_U}{N_S \le N_Sa \le N_U}.}

\item{X_S}{Object of predictors variables that can be coersed into a matrix.
The rows of \code{X_S} correspond to the rows of \code{y_S}.}

\item{X_Sa}{Object of predictor variables that can be coresed into a matrix.
The set \emph{Sa} is the intermediate sample.}

\item{Z_Sa}{Object of predictor variables that can be coresed into a matrix.
The set \emph{Sa} is the intermediate sample, and the Z-variables often some
sort of auxilairy, inexpensive data. The rows of \code{Z_Sa} correspond to
the rows of \code{X_Sa}}

\item{Z_U}{Object of predictor variables that can be coresed into a matrix.
The set \emph{U} is the universal population sample.}

\item{Omega_S}{The covariance structure of \eqn{\boldsymbol{\epsilon}_{S}}{
\epsilon_S}, up to a constant.}

\item{Phis_Sa}{A 3D array, where the third dimension corresponds to the
covariance structure of
\eqn{E(\boldsymbol{\xi}_{k,Sa} \boldsymbol{\xi}_{j,Sa}^T)}{
E(\xi_k,Sa \xi_j,Sa')},
in the order \eqn{k=1, \ldots, p, j=1, \ldots k}{k=1,...,p, j=1,...,k}.
For p = 3, the order (k,j) will thus be (1,1), (2,1), (2,2), (3,1), (3,2),
(3,3).}
}
\value{
A fitted object of class HMB.
}
\description{
Generalized Two-Staged Model-Based estmation
}
\details{
The GTSMB assumes the superpopulations
\deqn{y = \boldsymbol{x} \boldsymbol{\beta} + \epsilon}{
      y = x \beta + \epsilon}
\deqn{x_k = \boldsymbol{z} \boldsymbol{\gamma}_k + \xi_k}{
      x_k = z \gamma_k + \xi_k}
\deqn{\epsilon \perp \xi_k}{\epsilon indep. \xi_k}
For a sample from the superpopulation, the GTSMB assumes
\deqn{E(\boldsymbol{\epsilon}) = \mathbf{0},
      E(\boldsymbol{\epsilon} \boldsymbol{\epsilon}^T) = \omega^2 \boldsymbol{\Omega}}{
      E(\epsilon) = 0, E(\epsilon \epsilon') = \omega^2 \Omega}
\deqn{E(\boldsymbol{\xi}_k) = \mathbf{0},
      E(\boldsymbol{\xi}_k \boldsymbol{\xi}_j^T) = \theta_{\Phi,k,j}^2 \boldsymbol{\Phi}_{k,j},
      \theta_{\Phi,k,j}^2 \boldsymbol{\Phi}_{k,j} = \theta_{\Phi,j,k}^2 \boldsymbol{\Phi}_{j,k}}{
      E(\xi_k) = 0, E(\xi_k \xi_j') = \theta_Phi,k,j \Phi_k,j, \theta_Phi,k,j \Phi_k,j = \theta_Phi,j,k \Phi_j,k}
}
\examples{
pop_U   = sample(nrow(HMB_data), 20000)
pop_Sa  = sample(pop_U, 500)
pop_S   = sample(pop_U, 100)

y_S     = HMB_data[pop_S, "GSV"]
X_S     = HMB_data[pop_S, c("hMAX", "h80", "CRR")]
X_Sa    = HMB_data[pop_Sa, c("hMAX", "h80", "CRR")]
Z_Sa    = HMB_data[pop_Sa, c("B20", "B30", "B50")]
Z_U     = HMB_data[pop_U, c("B20", "B30", "B50")]

Omega_S = diag(1, nrow(X_S))
Phis_Sa = array(0, c(nrow(X_Sa), nrow(X_Sa), ncol(X_Sa) * (ncol(X_Sa) + 1) / 2))
Phis_Sa[, , 1] = diag(1, nrow(X_Sa)) # Phi(1,1)
Phis_Sa[, , 2] = diag(1, nrow(X_Sa)) # Phi(2,1)
Phis_Sa[, , 3] = diag(1, nrow(X_Sa)) # Phi(2,2)
Phis_Sa[, , 4] = diag(1, nrow(X_Sa)) # Phi(3,1)
Phis_Sa[, , 5] = diag(1, nrow(X_Sa)) # Phi(3,2)
Phis_Sa[, , 6] = diag(1, nrow(X_Sa)) # Phi(3,3)

gtsmb_model = gtsmb(y_S, X_S, X_Sa, Z_Sa, Z_U, Omega_S, Phis_Sa)
gtsmb_model
}
\references{
Holm, S., Nelson, R. & Ståhl, G. (2017) Hybrid three-phase estimators for large-area forest inventory using ground plots, 
airborne lidar, and space lidar. \emph{Remote Sensing of Environment, 197,} 85–97.

Saarela, S., Holm, S., Healey, S.P., Andersen, H.-E., Petersson, H., Prentius, W., Patterson, P.L., Næsset, E., Gregoire, T.G. & Ståhl, G. (2018). 
Generalized Hierarchical Model-Based Estimation for Aboveground Biomass Assessment Using GEDI and Landsat Data, \emph{Remote Sensing, 10(11),} 1832.
}
\seealso{
\code{\link{summary}},
\code{\link{getSpec}}.
}
