% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation_export.R
\name{export_data}
\alias{export_data}
\title{Export Data to Various Formats (CSV/STATA/TEXT/RDS/XLSX)}
\usage{
export_data(
  data,
  output_path,
  format = "csv",
  prefix = "",
  create_subfolder = FALSE,
  multi_sheet_xlsx = FALSE,
  xlsx_filename = NULL,
  report_output = FALSE
)
}
\arguments{
\item{data}{A list or data frame. The SL4 or HAR data to export.}

\item{output_path}{Character. The base output directory or file path.}

\item{format}{Character. The export format (\code{"csv"}, \code{"stata"}, \code{"txt"}, \code{"rds"}, \code{"xlsx"}). Default is \code{"csv"}.}

\item{prefix}{Character. An optional prefix added to exported file names. Default is \code{""} (empty).}

\item{create_subfolder}{Logical. If \code{TRUE}, creates a subfolder for each format. Default is \code{FALSE}.}

\item{multi_sheet_xlsx}{Logical. If TRUE, exports lists as multi-sheet XLSX files.}

\item{xlsx_filename}{An optional filename for the XLSX file (used when \code{multi_sheet_xlsx = TRUE}).}

\item{report_output}{Logical. If TRUE, generates an export report.}
}
\value{
A list containing the file paths of the exported data.
}
\description{
Exports structured SL4 or HAR data to multiple file formats, including CSV, Stata, TXT, RDS, and XLSX.
Supports nested lists, automatic subfolder creation, and multi-sheet Excel exports.
}
\details{
\itemize{
\item Supports exporting data in \code{"csv"}, \code{"stata"}, \code{"txt"}, \code{"rds"}, and \code{"xlsx"} formats.
\item Handles nested lists and exports each data frame individually.
\item Optionally creates subfolders for each format (\code{create_subfolder = TRUE}).
\item Customizes file names using \code{prefix}.
\item When multi_sheet_xlsx = TRUE, all exported data is stored in a \strong{single Excel workbook}, with each dataset as a separate sheet.
}

\itemize{
\item If exporting to Stata (\code{"stata"} format), column names containing \code{.} will be replaced with \verb{_} to ensure compatibility.
\item If \code{multi_sheet_xlsx = TRUE}, list elements are exported as separate sheets in a single XLSX file.
\item The function creates necessary directories if they do not exist.
}
}
\examples{
\donttest{
# Import sample data:
sl4_data <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))

# Extract data
data_multiple <- get_data_by_var(c("qo", "pca"), sl4_data)

# Export
export_data(data_multiple, file.path(tempdir(), "output_directory"), 
           format = c("csv", "xlsx", "stata", "txt", "rds"),
           create_subfolder = TRUE,
           multi_sheet_xlsx = TRUE)
}

}
\seealso{
\code{\link{pivot_data}}, \code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
