% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_manipulation_export.R
\name{pivot_data_hierarchy}
\alias{pivot_data_hierarchy}
\title{Create Hierarchical Pivot Table from SL4 or HAR Objects}
\usage{
pivot_data_hierarchy(
  data_obj,
  pivot_cols,
  name_repair = "unique",
  export = FALSE,
  file_path = NULL,
  xlsx_filename = NULL
)
}
\arguments{
\item{data_obj}{A list or data frame. The SL4 or HAR data to pivot.}

\item{pivot_cols}{Character vector. Column names to use as pivot keys in order of hierarchy.}

\item{name_repair}{Character. Method for handling duplicate column names
(\code{"unique"}, \code{"minimal"}, \code{"universal"}). Default is \code{"unique"}.}

\item{export}{Logical. If \code{TRUE}, exports result to Excel. Default is \code{FALSE}.}

\item{file_path}{Character. Required if export = TRUE. The path for Excel export.}

\item{xlsx_filename}{Character. The name for the Excel file when using multi_sheet_xlsx. If NULL, uses the name of the dataset. Default is \code{NULL}.}
}
\value{
A pivoted data object with hierarchical structure:
\itemize{
\item If input is a data frame: Returns a hierarchical pivot table.
\item If input is a list: Returns a nested list of hierarchical pivot tables.
\item If export = TRUE: Invisibly returns the pivoted object after Excel export.
}
}
\description{
Creates hierarchical pivot tables from structured SL4 or HAR data, with optional Excel export.
Supports both single data frames and nested lists, preserving dimension hierarchies.
}
\details{
\itemize{
\item Transforms data into hierarchical pivot format with nested column headers.
\item Supports multiple pivot columns in specified order (e.g., REG > COMM).
\item Handles both single data frames and nested list structures.
\item Optional direct export to Excel with formatted hierarchical headers.
\item Uses efficient data processing with tidyr and openxlsx.
}
}
\examples{
\donttest{
# Import sample data:
sl4_data <- load_sl4x(system.file("extdata", "TAR10.sl4", package = "HARplus"))

# Extract data
data_multiple <- get_data_by_var(c("qo", "pca"), sl4_data)

# Create hierarchical pivot without export
pivot_hier <- pivot_data_hierarchy(data_multiple, 
                                   pivot_cols = c("REG", "COMM"))

# Create and export to Excel in one step
pivot_export <- pivot_data_hierarchy(data_multiple, 
                                     pivot_cols = c("REG", "COMM"),
                                     export = TRUE,
                                     file_path = file.path(tempdir(), "pivot_output.xlsx"))
}

}
\seealso{
\code{\link{pivot_data}}
}
\author{
Pattawee Puangchit
}
