% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_commits.R
\name{get_commits}
\alias{get_commits}
\title{Get data on commits}
\usage{
get_commits(
  gitstats,
  since = NULL,
  until = Sys.Date() + lubridate::days(1),
  cache = TRUE,
  verbose = is_verbose(gitstats),
  progress = verbose
)
}
\arguments{
\item{gitstats}{A \code{GitStats} object.}

\item{since}{A starting date.}

\item{until}{An end date.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}

\item{progress}{A logical, by default set to \code{verbose} value. If \code{FALSE} no
\code{cli} progress bar will be displayed.}
}
\value{
A table of \code{tibble} and \code{gitstats_commits} classes.
}
\description{
List all commits from all repositories for an organization or a
vector of repositories.
}
\examples{
\dontrun{
my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    repos = c("openpharma/DataFakeR", "openpharma/visR")
  ) \%>\%
  set_gitlab_host(
    token = Sys.getenv("GITLAB_PAT_PUBLIC"),
    orgs = "mbtests"
  )
 get_commits(my_gitstats, since = "2018-01-01")
}
}
