% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{findVariableFeatures_wfilters}
\alias{findVariableFeatures_wfilters}
\title{Find variable features}
\usage{
findVariableFeatures_wfilters(
  obj,
  nfeatures = 2000,
  genesBlockList = NULL,
  min.exp = 0.01,
  max.exp = 3
)
}
\arguments{
\item{obj}{A Seurat object containing an expression matrix}

\item{nfeatures}{Number of top HVG to be returned}

\item{genesBlockList}{Optionally takes a vector or list of vectors of gene names.
These genes will be ignored for HVG detection. This is useful to mitigate effect
of genes associated with technical artifacts or batch effects
(e.g. mitochondrial, heat-shock response). If set to `NULL` no genes will be excluded}

\item{min.exp}{Minimum average normalized expression for HVG. If lower, the gene will be excluded}

\item{max.exp}{Maximum average normalized expression for HVG. If higher, the gene will be excluded}
}
\value{
Returns the input Seurat object \code{obj} with the calculated highly 
    variable features accessible through \code{VariableFeatures(obj)}
}
\description{
Select highly variable genes (HVG) from an expression matrix. Genes from a blocklist
(e.g. cell cycling genes, mitochondrial genes) can be excluded from the list of
variable genes, as well as genes with very low or very high average expression
}
\examples{
data(sampleObj)
sampleObj <- findVariableFeatures_wfilters(sampleObj, nfeatures=100)

}
