% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_speed.R
\name{edit_speed}
\alias{edit_speed}
\title{Adjust Travel Speed in a GTFS Dataset}
\usage{
edit_speed(gtfs, trips = "all", stops = "all", factor)
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function attempts to convert it using `GTFSwizard::as_wizardgtfs()`.}

\item{trips}{A character vector specifying the `trip_id`s to modify. Defaults to `"all"` to include all trips.}

\item{stops}{A character vector specifying the `stop_id`s to include in the adjustment. Defaults to `"all"` to include all stops.}

\item{factor}{A numeric value representing the multiplier for the speed. For example, a value of `2` doubles the speed, halving the travel time.}
}
\value{
A GTFS object with updated `stop_times` reflecting the adjusted travel durations.
}
\description{
The `edit_speed` function adjusts the travel speeds between stops in a GTFS dataset by modifying trip durations based on a specified speed multiplier. It allows selective adjustments for specific trips and stops or applies changes globally across the dataset.
}
\details{
The function performs the following steps:
\describe{
  \item{1. Retrieve Durations}{The `get_durations()` function calculates trip durations, filtered by the specified trips and stops.}
  \item{2. Adjust Durations}{Durations are divided by the speed factor to compute new durations. Time differences are calculated.}
  \item{3. Update Stop Times}{Cumulative time differences are added to the `arrival_time` and `departure_time` columns in the `stop_times` table.}
}
If no specific trips or stops are provided, the function adjusts all trips and stops in the GTFS object.
}
\note{
Ensure that the `factor` is greater than 0. Using a value less than or equal to 0 will result in invalid or nonsensical time adjustments.
}
\examples{
edit_speed(for_rail_gtfs,
          trips = for_rail_gtfs$trips$trip_id[1:2],
          stops = for_rail_gtfs$stops$stop_id[1:2],
          factor = 1.5)

}
\seealso{
[GTFSwizard::get_speeds()]
}
