% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simData.R
\name{simData}
\alias{simData}
\title{Simulate data}
\usage{
simData(
  n = 200,
  p = 10,
  L = 3,
  Sigma = NULL,
  kappas = 2,
  proportion.model = "dirichlet",
  model = "GPTCM"
)
}
\arguments{
\item{n}{number of subjects}

\item{p}{number of covariates in each cluster}

\item{L}{number of clusters}

\item{Sigma}{NULL (for a default covariance matrix) or "independent"
(i.e. Sigma=diag(p*L)) or a self-defined matrix}

\item{kappas}{value of the Weibull's shape parameter}

\item{proportion.model}{One of \code{c("alr", "cloglog", "log", "dirichlet")}}

\item{model}{one of \code{c("GPTCM", "Cox")}}
}
\value{
An object of a list with 12 components
\itemize{
\item "\code{survObj}" - a list including events and times
\item "\code{accepted}" - a vector with acceptance rates to generate each time-to-event data point by Metropolis-Hastings algorithm.
\item "\code{proportion.model}" - value to indicate the model type for simulating proportions data.
\item "\code{proportion}" - a matrix with simulated proportions data.
\item "\code{kappas}" - value of the Weibull's shape parameter.
\item "\code{x0}" - a matrix with the data of clinical variables
\item "\code{X}" - an array with cluster-specific covariates
\item "\code{xi}" - effects of clinical variables
\item "\code{beta0}" - intercepts related to cluster-specific-survival.
\item "\code{betas}" - effects related to cluster-specific-survival.
\item "\code{zetas}" - effects related to cluster-specific-proportions.
\item "\code{mrfG}" - a graph corresponding to the precision matrix of cluster-specific covariates
\item "\code{mrfG2}" - a graph corresponding to every second edge in "\code{mrfG}"
}
}
\description{
Simulate survival data based on a GPTCM or Cox model
}
\examples{

# simulate data
set.seed(123)
n <- 200 # subjects
p <- 10 # variable selection predictors
L <- 3 # cell types
dat <- simData(n, p, L)
str(dat)

}
\references{
Zhao Z, Kızılaslan F, Wang S, Zucknick M (2025). \emph{Generalized promotion time cure model: A new modeling framework to identify cell-type-specific genes and improve survival prognosis}. arXiv:2509.01001
}
