% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_tum_wwk_short.R
\name{validate_fe_species_tum_wwk_short}
\alias{validate_fe_species_tum_wwk_short}
\title{Validate an \emph{fe_species_tum_wwk_short} Object}
\usage{
validate_fe_species_tum_wwk_short(x = character())
}
\arguments{
\item{x}{An object that is expected to be a correct
\code{fe_species_tum_wwk_short} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the
\code{fe_species_tum_wwk_short} object specifications. In case of such
violations, the function will terminate with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor
\code{\link{new_fe_species_tum_wwk_short}}. Regular users, please construct
\code{fe_species_tum_wwk_short} objects with
\code{\link{fe_species_tum_wwk_short}}.
}
\examples{
# Passes validation
spec_ids <- as.character(c(2, 2, 2, 1, 1, 1, 1, 3, 3, 9))
spec_ids <- new_fe_species_tum_wwk_short(spec_ids)
validate_fe_species_tum_wwk_short(spec_ids)

# Validating the following spec_ids throws an error due to
# non-supported species codes
spec_ids <- as.character(c(2, 2, 52, 1, 1, 1, 123, 3, 3, 9))
spec_ids <- new_fe_species_tum_wwk_short(spec_ids)
try(
  validate_fe_species_tum_wwk_short(spec_ids)
)

}
