% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_gfft.R
\name{flip_exits}
\alias{flip_exits}
\title{Flip exits in an FFT definition}
\usage{
flip_exits(fft, nodes = NA, quiet = FALSE)
}
\arguments{
\item{fft}{One FFT definition
(as a data frame in tidy format, with one row per node).}

\item{nodes}{The FFT nodes whose exits are to be flipped (as an integer vector).
Default: \code{nodes = NA}.}

\item{quiet}{Hide feedback messages (as logical)?
Default: \code{quiet = FALSE}.}
}
\value{
One FFT definition
(as a data frame in tidy format, with one row per node).
}
\description{
\code{flip_exits} reverses the exits of
one or more \code{nodes} from an existing FFT definition
(in the tidy data frame format).

\code{flip_exits} alters the value(s) of the non-final
exits specified in \code{nodes} (from 0 to 1, or from 1 to 0).
By contrast, exits of final \code{nodes} remain unchanged.

Duplicates in \code{nodes} are flipped only once
(rather than repeatedly) and \code{nodes} not in
the range \code{1:nrow(fft)} are ignored.

\code{flip_exits} is a more specialized function
than \code{\link{edit_nodes}}.
}
\seealso{
\code{\link{add_nodes}} for adding nodes to an FFT definition;
\code{\link{edit_nodes}} for editing nodes in an FFT definition;
\code{\link{drop_nodes}} for deleting nodes from an FFT definition;
\code{\link{reorder_nodes}} for reordering nodes of an FFT definition;
\code{\link{select_nodes}} for selecting nodes in an FFT definition;
\code{\link{get_fft_df}} for getting the FFT definitions of an \code{FFTrees} object;
\code{\link{read_fft_df}} for reading one FFT definition from tree definitions;
\code{\link{add_fft_df}} for adding FFTs to tree definitions;
\code{\link{FFTrees}} for creating FFTs from and applying them to data.

Other tree definition and manipulation functions: 
\code{\link{add_fft_df}()},
\code{\link{add_nodes}()},
\code{\link{drop_nodes}()},
\code{\link{edit_nodes}()},
\code{\link{get_fft_df}()},
\code{\link{read_fft_df}()},
\code{\link{reorder_nodes}()},
\code{\link{select_nodes}()},
\code{\link{write_fft_df}()}
}
\concept{tree definition and manipulation functions}
