% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_quantiles.R
\name{get_quantiles.fars}
\alias{get_quantiles.fars}
\title{Extract Quantiles from a \code{fars} Object}
\usage{
\method{get_quantiles}{fars}(x, stressed = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{fars}.}

\item{stressed}{Logical. If \code{TRUE}, the function returns the stressed quantiles. If \code{FALSE} (default), it returns the non-stressed quantiles.}

\item{...}{Additional arguments (ignored).}
}
\value{
A matrix containing either the non-stressed quantiles or the stressed quantiles, depending on the value of \code{stressed}.
If stressed quantiles are requested but not available, it returns NULL.
}
\description{
Extracts either the non-stressed quantiles or the stressed quantiles from a \code{fars} object, depending on the \code{stressed} parameter.
If the requested stressed quantiles are not available, it returns NULL.
}
\examples{
fars_result <- compute_fars(dep_variable = rnorm(100), factors = matrix(rnorm(100 * 3), ncol = 3))
get_quantiles(fars_result)  

}
