% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Connection.R
\name{getDatabaseFile}
\alias{getDatabaseFile}
\title{Create a copy of a Eunomia dataset}
\usage{
getDatabaseFile(
  datasetName,
  cdmVersion = "5.3",
  pathToData = Sys.getenv("EUNOMIA_DATA_FOLDER"),
  dbms = "sqlite",
  databaseFile = tempfile(fileext = paste0(".", dbms)),
  inputFormat = "csv",
  verbose = FALSE,
  overwrite = TRUE
)
}
\arguments{
\item{datasetName}{The data set name as found on https://github.com/OHDSI/EunomiaDatasets. The
data set name corresponds to the folder with the data set ZIP files}

\item{cdmVersion}{The OMOP CDM version. This version will appear in the suffix of the data file,
for example: <datasetName>_<cdmVersion>.zip. Default: '5.3'}

\item{pathToData}{The path where the Eunomia data is stored on the file system., By default the
value of the environment variable "EUNOMIA_DATA_FOLDER" is used.}

\item{dbms}{The database system to use. "sqlite" (default) or "duckdb"}

\item{databaseFile}{The path where the database file will be copied to. By default, the database
will be copied to a temporary folder, and will be deleted at the end of the R
session.}

\item{inputFormat}{The format of the files expected in the archive. (csv or parquet)}

\item{verbose}{Provide additional logging details during execution}

\item{overwrite}{Remove and replace an existing data set.}
}
\value{
The file path to the new Eunomia dataset copy
}
\description{
Creates a copy of a Eunomia database, and returns the path to the new database file.
If the dataset does not yet exist on the user's computer it will attempt to download the source data
to the the path defined by the EUNOMIA_DATA_FOLDER environment variable.
}
\examples{
\dontrun{
 conn <- DBI::dbConnect(RSQLite::SQLite(), getDatabaseFile("GiBleed"))
 DBI::dbDisconnect(conn)

 conn <- DBI::dbConnect(duckdb::duckdb(), getDatabaseFile("GiBleed", dbms = "duckdb"))
 DBI::dbDisconnect(conn, shutdown = TRUE)

 conn <- DatabaseConnector::connect(dbms = "sqlite", server = getDatabaseFile("GiBleed"))
 DatabaseConnector::disconnect(conn)
}

}
