% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.maxlogL}
\alias{residuals.maxlogL}
\title{Extract Residuals from \code{maxlogL} model.}
\usage{
\method{residuals}{maxlogL}(object, parameter = NULL, type = c("deviance", "response"), ...)
}
\arguments{
\item{object}{an object of \code{\link{maxlogL}} class which summary is desired.}

\item{parameter}{a character which specifies the parameter whose normalized
quantile residuals will be computed.}

\item{type}{a character with the type of residuals to be computed required.
The default value is \code{type = "rqres"}, which is used to
compute the normalized randomized quantile residuals.}

\item{...}{for extra arguments.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{residuals.,axlogL} is the \code{maxlogLreg} specific method for the
generic function residuals which extracts the residuals from a fitted model.
}
\details{
For \code{type = "deviance"}, the residuals are computed using the following
expression

\deqn{r^D_i = \mbox{sign}(y_i - \hat{\mu}_i) d_i^{1/2},}

where \eqn{d_i} is the residual deviance of each data point. In this context,
\eqn{\hat{\mu}} is the estimated mean, computed as the expected value using
the estimated parameters of a fitted \code{maxlogLreg} model.

On the other hand, for \code{type = "response"} the computation is simpler

\deqn{r^R_i = (y_i - \hat{\mu}_i).}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
