% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_long_1d.R
\name{monitor_long_1d}
\alias{monitor_long_1d}
\title{Monitor Univariate Longitudinal Data}
\usage{
monitor_long_1d(
  data_matrix_new,
  time_matrix_new,
  nobs_new,
  pattern,
  side = "upward",
  chart = "CUSUM",
  method = "standard",
  parameter = 0.5,
  CL = Inf
)
}
\arguments{
\item{data_matrix_new}{observed data arranged in a numeric matrix format. \cr
\code{data_matrix_new[i,j]} is the jth observation of the ith subject.}

\item{time_matrix_new}{observation times arranged in a numeric matrix format. \cr
\code{time_matrix_new[i,j]} is the jth observation time of the ith subject. \cr
\code{data_matrix_new[i,j]} is observed at \code{time_matrix_new[i,j]}.}

\item{nobs_new}{number of observations arranged as an integer vector. \cr
\code{nobs_new[i]} is the number of observations for the ith subject.}

\item{pattern}{the estimated regular longitudinal pattern}

\item{side}{a character value specifying the sideness/direction of process monitoring\cr
If \code{side="upward"}{apply control charts that aim to detect upward shifts.} \cr
If \code{side="downward"}{apply control charts that aim to detect downward shifts.} \cr
If \code{side="both"}{apply control charts that aim to detect shifts in both sides}}

\item{chart}{a string specifying the control charts to use.
If \code{chart="CUSUM"}{apply CUSUM charts.} \cr
If \code{chart="EWMA"}{apply EWMA charts.}}

\item{method}{a string \cr
If \code{method="standard"}, standardize observations by mean and variance (cf., Qiu and Xiang, 2014).\cr
If \code{method="decorrelation"}, standardize and decorrelate observations by mean and covariance (cf., Li and Qiu, 2016).\cr
If \code{method="sprint"}, standardize and decorrelate observations within sprint length by mean and covariance (cf., You and Qiu 2018).\cr
If \code{method="distribution and standard"}, standardize observations by distribution (cf., You and Qiu, 2020).\cr
If \code{method="distribution and decorrelation"}, standardize observations by distribution and covariance (cf., You and Qiu, 2020).\cr
If \code{method="distribution and sprint"},standardize and decorrelate observations within sprint length by distribution and covariance (cf., You and Qiu, 2020).\cr
\code{method="nonparametric and standard"} currently not supported.\cr
\code{method="nonparametric and decorrelation"} currently not supported}

\item{parameter}{a numeric value \cr
If \code{chart="CUSUM"}, \code{parameter} is the allowance constant in the control chart.\cr
If \code{chart="EWMA"}, \code{parameter} is the weighting in the control chart.}

\item{CL}{a numeric value speficying the control limit. \cr
A signal will be given if charting statistics are larger than the control limit. 
(Note: in this package, signs of charting statistics may be reversed such that 
larger values of charting statistics indicate worse performance of processes.)
After the signal is given, the algorithm stops calculating the charting statistics for the remaining observation times.
The default value of control limit is infinity, which means we will calculate the charting statistics for all observation times.}
}
\value{
a list that stores the result.\cr
\item{$chart}{a numeric matrix, \code{$chart[i,j]} is the jth charting statistic of the ith subject.}
\item{$standardized_values}{a numeric matrix, \code{$standardized_values[i,j]} is the standardized value of the jth observation of the ith subject.}
}
\description{
Monitor Univariate Longitudinal Data
}
\examples{
data("data_example_long_1d")

result_pattern<-estimate_pattern_long_1d(
  data_matrix=data_example_long_1d$data_matrix_IC,
  time_matrix=data_example_long_1d$time_matrix_IC,
  nobs=data_example_long_1d$nobs_IC,
  design_interval=data_example_long_1d$design_interval,
  n_time_units=data_example_long_1d$n_time_units,
  estimation_method="meanvar",
  smoothing_method="local linear",
  bw_mean=0.1,
  bw_var=0.1)

result_monitoring<-monitor_long_1d(
  data_matrix_new=data_example_long_1d$data_matrix_OC,
  time_matrix_new=data_example_long_1d$time_matrix_OC,
  nobs_new=data_example_long_1d$nobs_OC,
  pattern=result_pattern,
  side="upward",
  chart="CUSUM",
  method="standard",
  parameter=0.5)
}
\references{
Qiu, P. and Xiang, D. (2014). Univariate dynamic screening system: an approach for identifying individuals with irregular longitudinal behavior. Technometrics, 56:248-260. \cr
Li, J. and Qiu, P. (2016). Nonparametric dynamic screening system for monitoring correlated longitudinal data. IIE Transactions, 48(8):772-786. \cr
You, L. and Qiu, P. (2019). Fast computing for dynamic screening systems when analyzing correlated data. Journal of Statistical Computation and Simulation, 89(3):379-394. \cr
You, L., Qiu, A., Huang, B., and Qiu, P. (2020). Early detection of severe juvenile idiopathic arthritis by sequential monitoring of patients' health-related quality of life scores. Biometrical Journal, 62(5). \cr
You, L. and Qiu, P. (2021). A robust dynamic screening system by estimation of the longitudinal data distribution. Journal of Quality Technology, 53(4).
}
