% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projMap2Cube.R
\name{projMap2Cube}
\alias{projMap2Cube}
\title{\
reshape a data matrix from projective mapping
into a brick of data for a \code{distatis} analysis.}
\usage{
projMap2Cube(Data, shape = "flat", nVars = 2, nBlocks = NULL)
}
\arguments{
\item{Data}{a data matrix that can be 
\eqn{I} rows by \eqn{J*K} columns (when \code{"flat"}) or
\eqn{I*K} rows by \eqn{J} columns when \code{"long"}.}

\item{shape}{(Default: \code{flat} when \code{"flat"} the data 
matrix has dimensions \eqn{I} rows by \eqn{J*K} columns;
when \code{"long"} the data  matrix has dimensions
\eqn{I*K} rows by \eqn{J} columns.}

\item{nVars}{Number of variables (default = 2),
relevant only when \code{shape = "flat"}.}

\item{nBlocks}{(Default = \code{NULL}) number
of Blocks (i.e., \eqn{K}) of \eqn{I} products.
Relevant only when    \code{shape = "long"}.}
}
\value{
An \eqn{I} by \eqn{J} by \eqn{K} array (i.e., a brick)
to be used to create a cube of distance or covariance.
}
\description{
\code{projMap2Cube} 
reshapes a data matrix from projective mapping
into a brick of data for a \code{distatis} analysis.
With \eqn{I} products, \eqn{J} variables, and
\eqn{K} blocks (assessors),
the original data can be 1) "flat" 
(e.g., \eqn{I} rows as products,
columns as \eqn{K} blocks of \eqn{J} Variables) 
or 2) "long"
"flat" (e.g., \eqn{K} blocks of 
\eqn{I} rows as products by assessors,
columns as \eqn{J} Variables).
}
\details{
the output \code{projMap2Cube} (i.e., the brick of data)
is used as input to the function \code{cubeOfCov} that will
create the cubeOfDistance (or covariance) that will be used
as input of \code{distatis}. 
\code{projMap2Cube} guesses the 
names of the products and variables from the
rownames and columns of the data, but this guess
needs to be verified.
}
\examples{
# Use the data from the BeersProjectiveMapping dataset
data("BeersProjectiveMapping")
# Create the I*J_k*K brick of data
dataBrick <- projMap2Cube(BeersProjectiveMapping$ProjectiveMapping, 
                        shape = 'flat',  nVars = 2)
}
\author{
Herve Abdi
}
