% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortDefinitionSet.R
\name{saveCohortDefinitionSet}
\alias{saveCohortDefinitionSet}
\title{Save the cohort definition set to the file system}
\usage{
saveCohortDefinitionSet(
  cohortDefinitionSet,
  settingsFileName = "inst/Cohorts.csv",
  jsonFolder = "inst/cohorts",
  sqlFolder = "inst/sql/sql_server",
  cohortFileNameFormat = "\%s",
  cohortFileNameValue = c("cohortId"),
  subsetJsonFolder = "inst/cohort_subset_definitions/",
  verbose = FALSE
)
}
\arguments{
\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{settingsFileName}{The name of the CSV file that will hold the cohort information
including the cohortId and cohortName}

\item{jsonFolder}{The name of the folder that will hold the JSON representation
of the cohort if it is available in the cohortDefinitionSet}

\item{sqlFolder}{The name of the folder that will hold the SQL representation
of the cohort.}

\item{cohortFileNameFormat}{Defines the format string  for naming the cohort
JSON and SQL files. The format string follows the
standard defined in the base sprintf function.}

\item{cohortFileNameValue}{Defines the columns in the cohortDefinitionSet to use
in conjunction with the cohortFileNameFormat parameter.}

\item{subsetJsonFolder}{Defines the folder to store the subset JSON}

\item{verbose}{When TRUE, logging messages are emitted to indicate export
progress.}
}
\description{
This function saves a cohortDefinitionSet to the file system and provides
options for specifying where to write the individual elements: the settings
file will contain the cohort information as a CSV specified by the
settingsFileName, the cohort JSON is written to the jsonFolder and the SQL
is written to the sqlFolder. We also provide a way to specify the
json/sql file name format using the cohortFileNameFormat and
cohortFileNameValue parameters.
}
