% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLargeScaleCharacteristics.R
\name{plotLargeScaleCharacteristics}
\alias{plotLargeScaleCharacteristics}
\title{create a ggplot from the output of summariseLargeScaleCharacteristics.}
\usage{
plotLargeScaleCharacteristics(
  result,
  facet = c("cdm_name", "cohort_name"),
  colour = "variable_level",
  style = "default"
)
}
\arguments{
\item{result}{A summarised_result object.}

\item{facet}{Columns to facet by. See options with
\code{availablePlotColumns(result)}. Formula is also allowed to specify rows and
columns.}

\item{colour}{Columns to color by. See options with
\code{availablePlotColumns(result)}.}

\item{style}{Named list that specifies how to style the different parts of
the table generated. It can either be a pre-defined style ("default" or
"darwin" - the latter just for gt and flextable), NULL to get the table
default style, or custom. Keep in mind that styling code is different for
all table styles. To see the different styles see \code{visOmopResults::tableStyle()}.}
}
\value{
A ggplot2 object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontrun{
library(CohortCharacteristics)
library(omock)
library(DrugUtilisation)

cdm <- mockCdmFromDataset(datasetName = "GiBleed", source = "duckdb")

cdm <- generateIngredientCohortSet(
  cdm = cdm, name = "my_cohort", ingredient = "acetaminophen"
)

resultsLsc <- cdm$my_cohort |>
  summariseLargeScaleCharacteristics(
    window = list(c(-365, -1), c(1, 365)),
    eventInWindow = "condition_occurrence"
  )

resultsLsc |>
  plotLargeScaleCharacteristics(
    facet = c("cdm_name", "cohort_name"),
    colour = "variable_level"
  )

cdmDisconnect(cdm)
}

}
