% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CovariateClass.R
\name{Covariate}
\alias{Covariate}
\title{Create a new Covariate object and validate it}
\usage{
Covariate(
  Name = character(),
  Type = "Continuous",
  StParmName = character(),
  State = "Present",
  Direction = "Forward",
  Center = "None",
  Categories = c(),
  Thetas = c(),
  Omegas = c(),
  PMLStructure = character()
)
}
\arguments{
\item{Name}{Character specifying the name of the covariate.}

\item{Type}{A character specifying the type of the covariate.
Possible values are:
\itemize{
\item \code{Continuous} A covariate  can take values on a continuous scale.
\item \code{Categorical} A covariate can only take a finite number of values.
\item \code{Occasion} The associated PK parameter may vary within an individual
from one event to the next, called interoccasion variability.
}}

\item{StParmName}{A character specifying the corresponding structural
parameter name.}

\item{State}{A character string representing the presence of the covariate on the structural parameters. Possible values are:
\itemize{
\item \code{None} The covariate does not have an effect on any structural parameter.
\item \code{Present} The covariate has an effect on the structural parameters (the default).
\item \code{Searched} The effect of the covariate on structural parameters is searched.
}}

\item{Direction}{A character string representing the direction of the
Covariate. Options are \code{Forward}, \code{Backward}, \code{Interpolate}. Default is
\code{Forward}. \code{Interpolate} is only applicable to \code{Type == "Continuous"}.}

\item{Center}{A character string (\code{None}, \code{Mean} or \code{Median}) or numeric
value representing the center of the Covariate. Default is \code{None}. Valid
only if \code{Type == "Continuous"}.}

\item{Categories}{A numeric vector representing the categories (at least two)
of the covariate. Applicable only if \code{Type} is either \code{Occasion} or
\code{Categorical}. The first category is set to the reference category for
categorical covariate.}

\item{Thetas}{A list of Theta objects representing  Thetas covariate effects.
Only applicable if \code{Type} is either \code{Categorical} or \code{Continuous}.
If \code{Type == "Continuous"}, one Theta corresponding to current Covariate
should be presented. If \code{Type == "Categorical"}, thetas corresponding to
each category (except the reference category) can be specified. If not
given, theta(s) will be automatically generated with initial estimate set
to 0.0.}

\item{Omegas}{A list of Omega objects representing the Omegas of
the inter-occasion random effects. Applicable only if \code{Type == "Occasion"}.
The number of Omegas should be equal to the number of categories provided.
If not given, Omegas will be created automatically with initial estimate
set to 1.0.}

\item{PMLStructure}{PML structure current Covariate instance belongs to.}
}
\value{
A Covariate object
}
\description{
Create a new Covariate object and validate it
}
\examples{
WT_Covariate <-
  Covariate(Name = "WT",
            Type = "Continuous",
            StParmName = "V",
            State = "Present",
            Direction = "Forward",
            Center = 70,
            Thetas = Theta("dVdWT", 1))

Race_Covariate <-
  Covariate(
    Name = "Race",
    Type = "Categorical",
    StParmName = "V2",
    State = "Searched",
    Direction = "Backward",
    Center = "None",
    Categories = c(1,2,3))

}
\seealso{
Functions used for Covariate specification: 
\code{\link{add_Covariate}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{remove_Covariate}()}
}
\concept{Covariates}
