% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_poly_terms}
\alias{add_poly_terms}
\title{Creates polynomial terms for specified variables in a data frame
Polynomial terms are named as \code{<variable>_d_<degree>} (e.g., \code{Z1_d_2} for the square of \code{Z1}).}
\usage{
add_poly_terms(data, Z, degree = 3, poly = TRUE)
}
\arguments{
\item{data}{Data frame. The data frame containing the variables for which polynomial terms are to be created.}

\item{Z}{Character vector. The names of the variables for which polynomial terms are to be created.}

\item{degree}{Integer. The maximum degree of polynomial terms to be created. Default is 3.}

\item{poly}{Logical. If TRUE, polynomial terms will be created. If FALSE, no polynomial terms will be created. Default is TRUE.}
}
\value{
A list with two components:
\itemize{
\item \code{data}: The modified data frame with added polynomial terms.
\item \code{new_terms}: A character vector of the names of the added polynomial terms (e.g., \code{Z1_d_2}).
}#'
}
\description{
Creates polynomial terms for specified variables in a data frame
Polynomial terms are named as \code{<variable>_d_<degree>} (e.g., \code{Z1_d_2} for the square of \code{Z1}).
}
\examples{
set.seed(123)
data_generator <-  function(N){
Z1 <- rnorm(N,0,1)
Z2 <- rnorm(N,0,1)
X <- rnorm(N, Z1 + Z2, 1)
Y <- rnorm(N, Z1 + Z2, 1)
df <- data.frame(Z1, Z2, X, Y)
return(df)
}
dat <- data_generator(250)
poly_terms <- add_poly_terms(data = dat, Z = c("Z1", "Z2"), degree = 3, poly = TRUE)
print(poly_terms$new_terms)
}
