# License for `BrazilDataAPI`

This package, `BrazilDataAPI`, is licensed under the **GNU General Public License Version 3 (GPL-3)**.

You are free to:

- Use, modify, and distribute the package, as long as any modifications or derived works also comply with the GPL-3.
- Distribute copies of this package with attribution, keeping this license intact.

## License Text

The full text of the GNU General Public License Version 3 (GPL-3) can be found [here](https://www.gnu.org/licenses/gpl-3.0.txt).

## Note on ArgentinaDatos and REST Countries

The `BrazilDataAPI` package depends on two public RESTful APIs for accessing Argentine and global data:

1. **BrasilAPI**

A community-driven open API that provides programmatic access to publicly available data in Brazil, such as postal codes (CEP), banks, company registrations, holidays, and more.

The project was created to offer modern, low-latency endpoints using edge caching via Vercel Smart CDN, enabling fast access to data even when the original sources are slow or lack features like CORS. It aims to make useful public information more accessible in a modern and reliable way.

- **Official site**: [https://brasilapi.com.br](https://brasilapi.com.br)  
- **License**: MIT  
- **Terms of Service**: The API is publicly accessible, does not require authentication, and is intended for experimental, educational, and analytical purposes.


2. **REST Countries API**  
   An open-source project that offers information about countries worldwide, including demographics, geography, and regional groupings.  
   This API is also publicly accessible and does not require authentication.  
   Website: [https://restcountries.com/](https://restcountries.com/)

As per the maintainers of both APIs, **no attribution is required** for using or distributing the data.  
However, we recommend reviewing the official documentation and usage terms on their respective websites to ensure proper understanding and responsible use.

## Note

The `BrazilDataAPI` package, including all its data files (.rda) and code files, is licensed under the GNU General Public License, version 3 or later (GPL-3).

## Copyright Notice

© 2025 Renzo Caceres Rossi. All rights reserved under the GPL-3.
