% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode_factors.R
\name{encode_factors}
\alias{encode_factors}
\title{Encode character variables as factor automatically}
\usage{
encode_factors(
  data,
  encode = c("character", "integer"),
  list_factors = NULL,
  uselist = FALSE
)
}
\arguments{
\item{data}{Dataframe to be encoded}

\item{encode}{Column class to be encoded. Must be "character" or "integer"}

\item{list_factors}{List of factors to be encoded}

\item{uselist}{Logical operator to determine if use list of factors or not. If TRUE, list_factors argument must be provided.}
}
\value{
Converts listed columns to factors.
}
\description{
Encode character variables as factor automatically
}
\examples{
df <- data.frame(has = c("Yes", "No", "Yes", "Yes", "No", "No", "Yes"),
smoke = c("Yes", "No", "No", "Yes", "No", "Yes", "No"),
gender = c("Male", "Female", "Male", "Female", "Female", "Male", "Male"))

str(df)

df <- encode_factors(df, encode = "character")

str(df)


}
