% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal-distributions.R
\name{marginal_inference}
\alias{marginal_inference}
\title{Model-average marginal posterior distributions and
marginal Bayes factors}
\usage{
marginal_inference(
  model_list,
  marginal_parameters,
  parameters,
  is_null_list,
  formula,
  null_hypothesis = 0,
  normal_approximation = FALSE,
  n_samples = 10000,
  seed = NULL,
  silent = FALSE
)
}
\arguments{
\item{model_list}{list of models, each of which contains marginal
likelihood estimated with bridge sampling \code{marglik} and prior model
odds \code{prior_weights}}

\item{marginal_parameters}{parameters for which the the marginal summary
should be created}

\item{parameters}{all parameters included in the model_list that are
relevant for the formula (all of which need to have specification of
\code{is_null_list})}

\item{is_null_list}{list with entries for each parameter carrying either
logical vector of indicators specifying whether the model corresponds
to the null or alternative hypothesis (or an integer vector indexing models
corresponding to the null hypothesis)}

\item{formula}{model formula (needs to be specified if \code{parameter} was part of a formula)}

\item{null_hypothesis}{point null hypothesis to test. Defaults to \code{0}}

\item{normal_approximation}{whether the height of prior and posterior density should be
approximated via a normal distribution (rather than kernel density). Defaults to \code{FALSE}.}

\item{n_samples}{number of samples to be drawn for the model-averaged
prior distribution}

\item{seed}{seed for random number generation}

\item{silent}{whether warnings should be returned silently. Defaults to \code{FALSE}}
}
\value{
\code{marginal_inference} returns an object of class 'marginal_inference'.
}
\description{
Creates marginal model-averaged and conditional
posterior distributions based on a list of models, vector of parameters,
formula, and a list of indicators of the null or alternative hypothesis models
for each parameter. Computes inclusion Bayes factors for each
marginal estimate via a Savage-Dickey density approximation.
}
\seealso{
\link{ensemble_inference} \link{mix_posteriors} \link{BayesTools_ensemble_tables}
}
