% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal-distributions.R
\name{Savage_Dickey_BF}
\alias{Savage_Dickey_BF}
\title{Compute Savage-Dickey inclusion Bayes factors}
\usage{
Savage_Dickey_BF(
  posterior,
  null_hypothesis = 0,
  normal_approximation = FALSE,
  silent = FALSE
)
}
\arguments{
\item{posterior}{marginal posterior distribution generated via the
\code{marginal_posterior} function}

\item{null_hypothesis}{point null hypothesis to test. Defaults to \code{0}}

\item{normal_approximation}{whether the height of prior and posterior density should be
approximated via a normal distribution (rather than kernel density). Defaults to \code{FALSE}.}

\item{silent}{whether warnings should be returned silently. Defaults to \code{FALSE}}
}
\value{
\code{Savage_Dickey_BF} returns a Bayes factor.
}
\description{
Computes Savage-Dickey (density ratio) inclusion Bayes factors
based the change of height from prior to posterior distribution at the test value.
}
