% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictHeight.R
\name{predictHeight}
\alias{predictHeight}
\title{Tree height predictions}
\usage{
predictHeight(D, model, err = FALSE, plot = NULL)
}
\arguments{
\item{D}{Vector of diameter (in cm).}

\item{model}{A height-diameter model output by the function \code{\link[=modelHD]{modelHD()}}}

\item{err}{If \code{TRUE}, An error is taken randomly from a normal distribution with a mean of
zero and a standard deviation equalled to the residual standard error of the model (RSE). Only used
for the Monte Carlo approach (see \code{\link[=AGBmonteCarlo]{AGBmonteCarlo()}}), otherwise it should be
let as \code{FALSE}, the default case.}

\item{plot}{(optional) Plot ID, must be either one value, or a vector of the same length as D. This argument is used to build
stand-specific HD models.}
}
\value{
Returns a vector of total tree height (in m).
}
\description{
The function predicts height from diameter based on a fitted model.
}
\details{
In the case where the error is \code{FALSE} and the model is a log-log model, we use the
Baskerville correction, a bias correction factor used to get unbiased backtransformation values.
}
\seealso{
\code{\link[minpack.lm:nlsLM]{minpack.lm::nlsLM()}}
}
\author{
Maxime REJOU-MECHAIN, Ariane TANGUY, Arthur PERE
}
\keyword{Internal}
