% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructAdjacency.R
\name{.adjDirect}
\alias{.adjDirect}
\title{Construct Adjacency Matrix for Parent-Child Relationships Using Direct Method}
\usage{
.adjDirect(
  ped,
  component,
  saveable,
  resume,
  save_path,
  verbose,
  lastComputed,
  checkpoint_files,
  update_rate,
  parList,
  lens,
  save_rate_parlist,
  config,
  ...
)
}
\arguments{
\item{ped}{a pedigree dataset.  Needs ID, momID, and dadID columns}

\item{component}{character.  Which component of the pedigree to return.  See Details.}

\item{saveable}{logical. If TRUE, save the intermediate results to disk}

\item{resume}{logical. If TRUE, resume from a checkpoint}

\item{save_path}{character. The path to save the checkpoint files}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{lastComputed}{the last computed index}

\item{checkpoint_files}{a list of checkpoint files}

\item{update_rate}{numeric. The rate at which to print progress}

\item{parList}{a list of parent-child relationships}

\item{lens}{a vector of the lengths of the parent-child relationships}

\item{save_rate_parlist}{numeric. The rate at which to save the intermediate results by parent list. If NULL, defaults to save_rate*1000}

\item{config}{a configuration list that passes parameters to the function}

\item{...}{additional arguments to be passed to \code{\link{ped2com}}}
}
\description{
This function constructs an adjacency matrix for parent-child relationships
using a direct method. It identifies parent-child pairs based on the
specified component of relatedness.
}
