% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_beam_result.R
\name{subset_beam_result}
\alias{subset_beam_result}
\title{Subset beam.stats Result}
\usage{
subset_beam_result(
  beam.result,
  beam.set.pvals = NULL,
  beam.feat.pvals = NULL,
  mtx.rows = NULL,
  set.ids = NULL,
  endpts = NULL,
  omics = NULL,
  p.limit = NULL,
  q.limit = NULL,
  p.feat.limit = NULL,
  q.feat.limit = NULL,
  intersect = TRUE,
  recalc = FALSE
)
}
\arguments{
\item{beam.result}{A beam.stats object from compute_beam_stats}

\item{beam.set.pvals}{A list containing BEAMR set p-values from compute_set_pvalues; required if p.limit or q.limit are specified.}

\item{beam.feat.pvals}{A list containing feature-level p-values from compute_feature_pvalues; required if p.feat.limit or q.feat.limit are specified.}

\item{mtx.rows}{A list of vectors of feature names corresponding to row.id in set.data. List names correspond to mtx.id in set.data. If specified, filter to all sets containing at least one of these features.}

\item{set.ids}{A character vector of set.ids. If specified, filter to these sets.}

\item{endpts}{A character vector of endpoint names. If specified, filter to sets that correspond to these endpoints.}

\item{omics}{A character vector of omics names. If specified, fitler to sets that correspond to these omics.}

\item{p.limit}{A numeric value. If specified, determine mtx.rows that are below this threshold if p<1 or top p sets if p>1.}

\item{q.limit}{A numeric value. If specified, determine mtx.rows that are below this threshold if q <1 or top q sets if q>1.}

\item{p.feat.limit}{A numeric value. If specified, determine mtx.rows that are below this threshold if p.feat<1 or top p.feat sets if p.feat>1 (feature p-values).}

\item{q.feat.limit}{A numeric value. If specified, determine mtx.rows that are below this threshold if q.feat<1 or top q.feat sets if q.feat>1.}

\item{intersect}{A logical value. Default is TRUE. If TRUE, use intersection of all specified criteria. If FALSE use union of all specified criteria.}

\item{recalc}{A logical value. Default is FALSE. If TRUE, recalculate p-values. If FALSE use original set p-values..}
}
\value{
A list with filtered beam.stats object, updated beam.set.pvals, and filtered beam.feat.pvals.
}
\description{
Filter the beam.stats object from compute_beam_stats with various filtering criteria. Default is to filter to top 50 sets with smallest q-value. At least one filtering criteria must be specified. Can also use intersection or union of multiple criteria.
}
\examples{
data(beam_stats)
test.pvals <- compute_set_pvalues(beam.stats=beam_stats)
test.feat.pvals <- compute_feature_pvalues(beam.stats=beam_stats)
filt.beam.stats <- subset_beam_result(beam_stats, test.pvals, test.feat.pvals,
                                      endpts=c("EFS","OS"), q.limit=10, intersect=TRUE,
                                      recalc=FALSE)
}
