% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{batss.glm}
\alias{batss.glm}
\title{Bayesian adaptive trial simulations for generalised linear models}
\usage{
batss.glm(
  model,
  var,
  var.control = NULL,
  family = "gaussian",
  link = "identity",
  beta,
  which,
  alternative = "greater",
  R = 10000,
  N,
  interim,
  prob0,
  delta.eff = 0,
  delta.fut = delta.eff,
  delta.RAR = 0,
  eff.arm,
  eff.arm.control = NULL,
  eff.trial = NULL,
  eff.trial.control = NULL,
  fut.arm,
  fut.arm.control = NULL,
  fut.trial = NULL,
  fut.trial.control = NULL,
  RAR = NULL,
  RAR.control = NULL,
  H0 = TRUE,
  computation = "parallel",
  mc.cores = getOption("mc.cores", 3L),
  extended = 0,
  ...
)
}
\arguments{
\item{model}{an object of class '\link[stats]{formula}' indicating a symbolic description of the model to be fitted (as in the \link[stats]{lm} and \link[stats]{glm} functions).}

\item{var}{A list. Each entry corresponds to a variable described under '\code{model}' and indicates the name of a function allowing to generate variates (like \link[stats]{rnorm} and \link[stats]{rexp}, for example). The list names have to match the variable names unded in '\code{model}' and its first element should correspond to the model outcome. The grouping variable corresponding to the target parameters has to be of class '\link[base]{factor}' with levels corresponding to the names indicated in argument \code{prob0} (see below).}

\item{var.control}{An optional list of control parameters for the functions indicated in '\code{var}'. The names of the list items need to correspond to the names used in '\code{var}'. Each element is another list with names of the elements corresponding to the parameter names of the functions specified in '\code{var}'.}

\item{family}{A character string indicating the name of the conditional distribution as described in the package INLA (check \link[INLA]{inla.list.models}). Default set to '\code{gaussian}'.}

\item{link}{A character string describing the link function to be used in the model to relate the outcome to the set of predictors: 'identity', 'log', 'logit', 'probit', 'robit', 'cauchit', 'loglog' and 'cloglog' are the currently available options. Default set to 'identity'.}

\item{beta}{A numerical vector of parameter values for the linear predictor. Its length has to match the number of column of the \strong{X} matrix induced by the formula indicated under '\code{model}' (check \link[stats]{model.matrix}).}

\item{which}{A numerical vector indicating the position of the target \code{beta} parameters.}

\item{alternative}{A vector of strings providing the one-sided direction of the alternative hypothesis corresponding to each target parameter indicated under '\code{which}' (in the same order). Possibilities are 'greater' (default) or 'less'. If the vector is of length 1, the same direction will be used for all target parameter tests.}

\item{R}{a vector of natural numbers to be used as seeds (check \link[base]{set.seed}) for the different Monte Carlo trials (the vector length will thus correspond to the number of Monte Carlo trials). When \code{R} is a scalar, seeds \code{1} to \code{R} are used, where \code{R} corresponds to the number of Monte Carlo trials.}

\item{N}{A scalar indicating the maximum sample size.}

\item{interim}{A list of parameters related to interim analyses. Currently, only '\code{recruited}' is available.  It consists in a vector of integers indicating the number of completed observations at each look, last excluded, in increasing order.}

\item{prob0}{A named vector with initial allocation probabilities. Names need to correspond to the levels of the grouping variable. If \code{RAR = NULL}, these probabilities/ratios will be used throughout (fixed allocation probabilities).}

\item{delta.eff}{A vector (of length equal to the number of looks (i.e., number of interims + 1)) of clinically meaningful treatment effect values (on the linear predictor scale) to be used to define the efficacy-related posterior probabilities for each target parameter at each look. If a scalar is provided, the same value is used at each look. The default is \code{delta.eff = 0}.}

\item{delta.fut}{A vector (of length equal to the number of looks (i.e., number of interims + 1)) of clinically meaningful treatment effect values (on the linear predictor scale) to be used to define the futility-related posterior probabilities for each target parameter at each look. If a scalar is provided, the same value is used at each look. The default is \code{delta.fut = delta.eff}.}

\item{delta.RAR}{A vector (of length equal to the number of looks (i.e., number of interims + 1)) of clinically meaningful treatment effect values (on the linear predictor scale) to be used to define the RAR-related posterior probabilities for each target parameter at each look. If a scalar is provided, the same value is used at each interim analysis. The default is \code{delta.RAR = 0}. Note that, when a vector is provided, its last value is ignored as no randomisation is made at the last look.}

\item{eff.arm}{A function defining if efficacy has been achieved at a given look given the information available at that stage a given target parameter. The output of this function must be a \link[base]{logical} (of length 1). Arguments of this function will typically consider 'BATSS' ingredients. Check \link{eff.arm.simple} and \link{eff.arm.infofract} for examples.}

\item{eff.arm.control}{An optional list of parameters for the function indicated in '\code{eff.arm}'.}

\item{eff.trial}{A function defining if the trial can be stopped for efficacy given the output of the function indicated in '\code{eff.arm}'. The output of this function must be a \link[base]{logical} of length one. Arguments of this function will typically only consider the 'BATSS' ingredient \code{eff.target}. Check \link{eff.trial.all} and \link{eff.trial.any} for examples. When \code{eff.trial = NULL} (default), the trial stops for efficacy when \emph{all} target parameters are found to be effective (like in \link{eff.trial.all}).}

\item{eff.trial.control}{An optional list of parameters for the function indicated in '\code{eff.trial}'.}

\item{fut.arm}{A function defining if futility has been achieved at a given look given the information available at that stage for each target parameter. The output of this function must be a \link[base]{logical} (of length 1). Arguments of this function will typically consider 'BATSS' ingredients. Check \link{fut.arm.simple} to see an example of such a function.}

\item{fut.arm.control}{An optional list of parameters for the function indicated in '\code{fut.arm}'.}

\item{fut.trial}{A function defining if the trial can be stopped for futility given the output of the function indicated in '\code{fut.arm}'. The output of this function must be a \link[base]{logical} of length one. Arguments of this function will typically only consider the 'BATSS' ingredient \code{fut.target}. Check \link{fut.trial.all} for an example of such a function. When \code{fut.trial = NULL} (default), the trial stops for futility when \emph{all} target parameters are found to be futile (like in \link{fut.trial.all}).}

\item{fut.trial.control}{An optional list of parameters for the function indicated in '\code{fut.trial}'.}

\item{RAR}{A function defining the response-adaptive randomisation probabilities of each group - reference group included - with the same group names and ordering as used in '\code{prob0}'. Arguments of this function will typically consider 'BATSS' ingredients. Check \link{RAR.trippa} and \link{RAR.optimal} for examples. If \code{RAR = NULL} (default), the probabilities/ratios indicated under \code{prob0} will be used throughout (fixed allocation probabilities).}

\item{RAR.control}{An optional list of control parameters for the function provided in '\code{RAR}'.}

\item{H0}{A logical indicating whether the simulation should also consider the case with all target parameters set to 0 to check the probability of rejecting the hypothesis that the target parameter value is equal to 0 individually (pairwise type I error) or globally (family-wise error rate). Default set to \code{H0=TRUE}.}

\item{computation}{A character string indicating how the computation should be performed. Possibilities are 'parallel' or 'sequential' with default \code{computation="parallel"} meaning that the computation is split between \code{mc.cores}.}

\item{mc.cores}{An integer indicating the number of CPUs to be used when \code{computation="parallel"} (Default to 3 if no global '\code{mc.cores}' global option is available via \link[base]{getOption}).}

\item{extended}{an integer indicating the type of results to be returned. 0 (default) provides summary statistics, 1 adds the results of each Monte Carlo trial and 2 additionally returns each Monte Carlo dataset. \link{batss.combine} requires extended > 0 as the function needs to merge results of different sets of seeds.}

\item{...}{Additional arguments to control fitting in \link[INLA]{inla}.}
}
\value{
The function \link{batss.glm} returns an S3 object of class 'batss' with available print/summary/plot functions
\itemize{
\item beta - A data frame providing information related to the beta parameter vector, like parameter names and values, for example.
\item look - A data frame providing information related to looks, like sample size of a given interim (m) and cumulative sample size at a given interim (n), for example.
\item par - A list providing different information, like the used seeds (seed) and the groups (group), for example.
\item H1 - A list providing trial results under the alternative, like the estimates per target parameter when the corresponding arm was stopped (estimate), the efficacy and futility probabilites per target parameter and overall (target, efficacy and futility), the sample size per group and trial (sample), the probabilities associated to each combination of efficacy and futility per group (scenario), the detailed results per trial (trial), for example.
\item H0 - A list providing trial results under the global null hypothesis (same structure as H1).
\item call - The matched call.
\item type - The type of 'BATSS' analysis (only 'glm' is currently available).
}
}
\description{
Simulation of Bayesian adaptive trials with GLM endpoint using Integrated Nested Laplace Approximation (INLA).
}
\examples{
\donttest{
# Example: 
# * Gaussian conditional distribution with sigma = 5
# * 3 groups with group means 'C' = 1 (ref), 'T1' = 2, 'T2' = 3,
#     where higher means correspond to better outcomes 
# * 5 interim analyses occurring when n = 100, 120, 140, 160, and 180
# * fixed and equal allocation probabilities per arm (i.e., no RAR)
# * max sample size = 200 
# * efficacy stop per arm when the prob of the corresponding parameter 
#     being greater than 0 is greater than 0.975 (?eff.arm.simple)
# * futility stop per arm when the prob of the corresponding parameter 
#     being greater than 0 is smaller than 0.05 (?fut.arm.simple) 
# * trial stop once all arms have stopped (?eff.trial.all and ?fut.trial.all)
#     or the max sample size was reached 

sim = batss.glm(model            = y ~ group,   
                var              = list(y     = rnorm,
                                        group = alloc.balanced),
                var.control      = list(y = list(sd = 5)),
                beta             = c(1, 1, 2),
                which            = c(2:3),
                alternative      = "greater",
                R                = 20,
                N                = 200,
                interim          = list(recruited = seq(100, 180, 20)),
                prob0            = c(C = 1/3, T1 = 1/3, T2 = 1/3),
                eff.arm          = eff.arm.simple,
                eff.arm.control  = list(b = 0.975),
                fut.arm          = fut.arm.simple,
                fut.arm.control  = list(b = 0.05),
                computation      = "parallel",
                H0               = TRUE,
                mc.cores         = 2)# better: parallel::detectCores()-1
}
}
\seealso{
\link{summary.batss} and \link{plot.batss} for detailed summaries and plots, and \link{batss.combine} to combine different evaluations of \link{batss.glm} considering the same trial design but different sets of seeds (useful for cluster computation).
}
