% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_find_gamma.R
\name{AM_find_gamma_Delta}
\alias{AM_find_gamma_Delta}
\title{Given that the prior on M is a dirac delta, find the \eqn{\gamma} hyperparameter of the weights prior to match \eqn{E(K)=K*},
where \eqn{K*} is user-specified}
\usage{
AM_find_gamma_Delta(
  n,
  Mstar,
  Kstar = 6,
  gam_min = 1e-04,
  gam_max = 10,
  tolerance = 0.1
)
}
\arguments{
\item{n}{sample size.}

\item{Mstar}{number of components of the mixture.}

\item{Kstar}{mean number of clusters the user wants to specify.}

\item{gam_min}{lower bound of the interval in which \code{gamma} should lie (default 1e-4).}

\item{gam_max}{upper bound of the interval in which \code{gamma} should lie (default 10).}

\item{tolerance}{Level of tolerance for the method.}
}
\value{
A value of \code{gamma} such that \eqn{E(K)=K^*}
}
\description{
Once a fixed value of the number of components \eqn{M^*} is specified, this function  adopts a \emph{bisection method} to find the value of \eqn{\gamma}
such that the induced distribution on the number of clusters is centered around a user specifed value \eqn{K^*}, i.e. the function uses
a bisection method to solve for \eqn{\gamma} \insertCite{argiento2019infinity}{AntMAN}. The user can provide a lower \eqn{\gamma_{l}} and
an upper \eqn{\gamma_{u}} bound for the possible values of \eqn{\gamma}. The default values are \eqn{\gamma_l= 10^{-3}} and \eqn{\gamma_{u}=10}.
A default value for the tolerance is \eqn{\epsilon=0.1}. Moreover, after a maximum number of iteration (default is 31), the function
stops warning that convergence has not been reached.
}
\examples{
n <- 82
Mstar <- 12
gam_de <- AM_find_gamma_Delta(n,Mstar,Kstar=6, gam_min=1e-4,gam_max=10, tolerance=0.1)
prior_K_de <-  AM_prior_K_Delta(n,gam_de,Mstar)
prior_K_de\%*\%1:n
}
\keyword{clusters}
\keyword{number}
\keyword{of}
\keyword{prior}
