% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DuncanTest.R
\name{DuncanTest}
\alias{DuncanTest}
\title{Duncan Multiple Range Test (DMRT)}
\usage{
DuncanTest(modelo, alpha = 0.05)
}
\arguments{
\item{modelo}{An object of class \code{aov} or \code{lm}.}

\item{alpha}{Significance level (default is 0.05).}
}
\value{
An object of class \code{"duncan"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, mean differences,
  critical values, p-values, and significance indicators.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: A character vector with group names ordered from highest to lowest mean.
  \item \code{Metodo}: A character string indicating the comparison method ("Duncan").
}
}
\description{
Performs the Duncan test for pairwise comparisons after an ANOVA.
This method is more liberal than Tukey's HSD, using a stepwise approach
with critical values from the studentized range distribution.
}
\details{
Advantages:
- High power for detecting differences.
- Simple to interpret and implement.

Disadvantages:
- Inflates Type I error rate.
- Not recommended for confirmatory research.
}
\examples{
data(d_e, package = "Analitica")
mod <- aov(Sueldo_actual ~ as.factor(labor), data = d_e)
resultado <- DuncanTest(mod)
summary(resultado)
plot(resultado)
}
\references{
Duncan, D. B. (1955). "Multiple range and multiple F tests." Biometrics, 11(1), 1-42.
}
