% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{ranking.as_data}
\alias{ranking.as_data}
\title{Ranking Plot}
\usage{
\method{ranking}{as_data}(
  data_object,
  main = "Ranking",
  labels = NULL,
  test = TRUE,
  predictions = NULL,
  by_families = FALSE,
  ordered_option_names = NULL,
  xlab = "",
  ylab = "",
  ...
)
}
\arguments{
\item{data_object}{object of class \code{as_data}.}

\item{main}{an overall title for the plot.}

\item{labels}{character vector with the labels for each of the algorithms. If NULL, the y names of the \code{data_object} names will be used.}

\item{test}{flag that indicates whether the function should use test data or training data.}

\item{predictions}{a data frame with the predicted KPI for each algorithm (columns) and for each instance (rows). If NULL, the plot won't include a ML column.}

\item{by_families}{boolean indicating whether the function should represent data by families or not. The family information must be included in the \code{data_object} parameter.}

\item{ordered_option_names}{vector with the name of the columns of data_object y variable in the correct order.}

\item{xlab}{a label for the x axis.}

\item{ylab}{a label for the y axis.}

\item{...}{other parameters.}
}
\value{
A \code{ggplot} object representing the ranking of algorithms based on the instance-normalized KPI.
}
\description{
After ranking the algorithms for each instance, represents for each of the algorithms, a bar with the percentage of times it was in each of the ranking positions. The number inside is the mean value of the normalized response variable (KPI) for the problems for which the algorithm was in that ranking position. The option \code{predictions} allows to control if the "ML" algorithm is added to the plot.
}
\examples{
data(branchingsmall)
data <- partition_and_normalize(branchingsmall$x, branchingsmall$y)
training <- AStrain(data, method = "glm")
predict_test <- ASpredict(training, newdata = data$x.test)
ranking(data, predictions = predict_test)
}
