% File src/library/grDevices/man/glyphInfo.Rd
% Part of the R package, https://www.R-project.org
% Copyright 1995-2012 R Core Team
% Copyright 2002-2010 The R Foundation
% Distributed under GPL 2 or later

\name{glyphInfo}
\alias{glyphInfo}
\alias{glyphFont}
\alias{glyphFontVariation}
\alias{glyphFontList}
\alias{glyphAnchor}
\alias{glyphWidth}
\alias{glyphHeight}
\alias{glyphWidthLeft}
\alias{glyphHeightBottom}
\alias{glyphJust}
\alias{glyphJust.GlyphJust}
\alias{glyphJust.character}
\alias{glyphJust.numeric}
\title{Describe a Set of Typeset Glyphs}
\description{
  Create an object that contains information about typeset glyphs.
  This includes glyph identifiers, glyph locations, font, colour 
  and rotation information, and metric information.
}

\usage{
glyphInfo(id, x, y, font, size, fontList, 
          width, height, hAnchor, vAnchor,
          col=NA, rot=0)

glyphFont(file, index, family, weight, style, PSname=NA, variations=NULL)
glyphFontVariation(...)
glyphFontList(...)
glyphAnchor(value, label)
glyphWidth(w, label="width", left="left")
glyphHeight(h, label="height", bottom="bottom")
glyphWidthLeft(w, label)
glyphHeightBottom(h, label)
glyphJust(just, ...)
\method{glyphJust}{GlyphJust}(just, ...)
\method{glyphJust}{character}(just, ...)
\method{glyphJust}{numeric}(just, which=NULL, ...)
}
\arguments{
  \item{id}{Numeric vector of glyph identifiers (index of glyph within
    font file).}
  \item{x, y}{Numeric locations of glyphs in (big) points (1/72
    inches).}
  \item{font}{Integer index into \code{fontList}.}
  \item{size}{Numeric size of glyphs (in points).}
  \item{fontList}{List of glyph fonts, as generated by \code{glyphFont()}.}
  \item{width}{Overall width of glyphs.  Can be a single numeric value,
    but can also be the result from a call to \code{glyphWidth()}.}
  \item{height}{Overall height of glyphs.  Can be a single numeric
    value, but can also be the result from a call to \code{glyphHeight()}.}
  \item{hAnchor}{Horizontal anchors for justifying glyphs relative to the
    (\code{x}, \code{y}) location.  Can be a 
    single numeric value (against which to \code{"left"} justify),
    but can also be result from a call to \code{glyphAnchor()}.}
  \item{vAnchor}{Vertical anchors for justifying glyphs relative to the 
    (\code{x}, \code{y}) location.  Can be a single numeric value
    (against which to \code{"bottom"} justify), 
    but can also be result from a call to \code{glyphAnchor()}.}
  \item{col}{An R colour value for each glyph. Can be \code{NA}.}
  \item{rot}{The angle to rotate each glyph.}
  \item{file}{Character path to font file.}
  \item{index}{Numeric index of font within font file.}
  \item{family}{Character name of font family.}
  \item{weight}{Numeric weight of glyphs (400 is normal, 700 is bold).}
  \item{style}{Character style of glyphs (\code{"normal"}, \code{"italic"},
    or \code{"oblique"}).}
  \item{PSname}{The PostScript name for each font. Can be \code{NA}.}
  \item{variations}{Axis coordinate settings for variable fonts.  Either
    \code{NULL}, or a call to \code{glyphFontVariation()}, or a named vector,
    or a named list.}
  \item{value, w, h}{A numeric value.}
  \item{label, left, bottom}{A character value.}
  \item{just}{A justification value. Either a character value like
    \code{"left"} or a numeric value like \code{0}.}
  \item{which}{When \code{x} is numeric, a character value identifying
    which width metric the numeric value is relative to.}
  \item{\dots}{For \code{glyphFontList()}, one or more
    \code{glyphFont()}s. For \code{glyphFontVar()}, one or more named
    numeric values (see Details). Otherwise, further arguments passed to
    other methods.}
}
\value{
  The result from \code{glyphInfo()} is an \code{"RGlyphInfo"} object,
  essentially a data frame with each row
  containing id, location, font, colour and rotation for a glyph.
  The metric information (widths and anchors) are stored 
  as attributes of the data frame.

  \code{glyphAnchor()}, \code{glyphWidth()}, and \code{glyphHeight()}
  return values that can be used to specify \code{width}, \code{height},
  \code{hAnchor}, and \code{vAnchor} values to \code{glyphInfo()}.
}
\details{
  Multiple anchors can be specified so as to allow different
  character-based justifications of the glyphs relative to the
  (\code{x}, \code{y}) location.  Horizontal anchors with labels
  \code{"left"}, \code{"centre"}, and \code{"right"} are required.
  It is possible to specify a single numeric \code{hAnchor}, which is
  treated as the \code{"left"} anchor, or a single anchor with label
  \code{"left"}, in which case the other
  required anchors will be calculated based on the required width of the
  glyphs (see below).
  Vertical anchors with labels \code{"bottom"}, \code{"centre"}, and
  \code{"top"} are required.
  It is possible to specify a single numeric \code{vAnchor}, which is
  treated as the \code{"bottom"} anchor, or a single anchor with label
  \code{"bottom"}, in which case the other
  required anchors will be calculated based on the required height of the
  glyphs (see below).
  An example of a non-required anchor is a vertical anchor
  with the label \code{"baseline"} so that the glyphs can be placed with
  their baseline at the \code{y} location.

  Multiple widths and heights can be specified so as to allow different
  numeric-based justifications of the glyphs relative to the
  (\code{x}, \code{y}) location, e.g., \code{0} for left-justification
  and \code{1} for right-justification, but with any value in between
  or even outside those limits also possible.  
  A width with label \code{"width"}, relative to the \code{"left"}
  horizontal anchor, is required, but if a single
  numeric value is given, that is assumed to be the required width.
  A height with label \code{"height"}, relative to the \code{"bottom"}
  vertical anchor is required, but if a single
  numeric value is given, that is assumed to be the required height.
  An example of a non-required width is a \code{"tight"} width that
  is relative to a \code{"left-bearing"} horizontal anchor, so that
  the glyphs can be justified relative to a bounding box around the
  glyph ink, rather than a bounding box that includes left and right
  bearings.

  \code{glyphWidthLeft()} and \code{glyphWidthHeight()} provide
  an API for code that needs to access the relevant anchors for
  width and height metrics.

  \code{glyphFontVariation()} accepts arguments of the form \code{wght=100}.
  Every argument should be named, each name should be 4 ASCII characters
  long, each name should be either one of the standard axes
  (\I{wght}, \I{slnt}, \I{wdth}, \I{ital}, \I{opsz}), in lowercase, otherwise (if a
  custom axis) in uppercase.  Every argument value should be numeric.
}
\section{Warning}{
  Any glyph with \code{NA} in any of \code{id}, \code{x}, \code{y}, 
  \code{size} or \code{rot} is silently dropped.
}
