% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_coefficients}
\alias{plot_coefficients}
\title{Plot coefficient comparison across groups}
\usage{
plot_coefficients(object, equation = "mean", variable = NULL)
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{equation}{Character; "mean" or "variance"}

\item{variable}{Optional; specific variable to plot. If NULL, plots all}
}
\value{
A ggplot2 object
}
\description{
Plot coefficient comparison across groups
}
\examples{
\donttest{
# Requires ggplot2 package
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(456)
  n_id <- 30
  n_time <- 4
  panel_data <- data.frame(
    id = rep(1:n_id, each = n_time),
    group = rep(c("A", "B"), length.out = n_id * n_time),
    x = rnorm(n_id * n_time)
  )
  panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
  panel_data$d_x <- panel_data$x - panel_data$m_x
  panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)
  
  result <- xtvfreg(
    formula = y ~ 1,
    data = panel_data,
    group = "group",
    panel_id = "id",
    mean_vars = c("m_x", "d_x"),
    var_vars = "m_x",
    verbose = FALSE
  )
  
  # Plot coefficients
  plot_coefficients(result, equation = "mean")
}
}
}
