% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudomedian_ci.R
\name{pseudomedian_ci}
\alias{pseudomedian_ci}
\title{Confidence Interval for Hodges-Lehmann Pseudomedian via Test Inversion}
\usage{
pseudomedian_ci(x, y, conf.level = 0.95, pvalue_method = "EU", n_grid = 1000)
}
\arguments{
\item{x}{numeric vector, first sample}

\item{y}{numeric vector, second sample}

\item{conf.level}{confidence level (default 0.95)}

\item{pvalue_method}{character, either 'EU' or 'BC'}

\item{n_grid}{number of grid points for search (default 1000)}
}
\value{
list with conf.int, estimate and conf.level
}
\description{
Computes confidence interval for the pseudomedian under \eqn{\mathrm{H_0\colon AUC} = 0.5}{H0: AUC = 0.5}
by test inversion.
}
