% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_counting_helpers.R
\name{check_results}
\alias{check_results}
\title{Check and Compare Statistical Test Results}
\usage{
check_results(dfcount, verbose = TRUE)
}
\arguments{
\item{dfcount}{A list or data frame from \code{\link{df_counting}} containing:
\describe{
\item{lr}{Weighted log-rank statistic}
\item{sig2_lr}{Variance of the weighted log-rank statistic}
\item{z.score}{Standardized z-score from Cox model}
\item{logrank_results}{List containing \code{chisq}, the log-rank chi-squared statistic}
}}

\item{verbose}{Logical; if \code{TRUE}, prints the comparison table to the console.
Default: \code{TRUE}.}
}
\value{
A data frame with one row and three columns, returned invisibly:
\describe{
\item{zlr_sq}{Squared standardized weighted log-rank: \eqn{(lr / \sqrt{sig2\_lr})^2}}
\item{logrank_chisq}{Chi-squared statistic from log-rank test}
\item{zCox_sq}{Squared z-score from Cox model: \eqn{z.score^2}}
}
}
\description{
Calculates and compares three equivalent test statistics from weighted survival analysis:
the squared standardized weighted log-rank statistic, the log-rank chi-squared statistic,
and the squared Cox model z-score. These should be approximately equal under correct implementation.
}
\details{
This function serves as a diagnostic tool to verify computational consistency.
The three statistics should be numerically equivalent (within rounding error):
\deqn{(lr / \sqrt{sig2\_lr})^2 \approx logrank\_chisq \approx z.score^2}

Discrepancies between these values may indicate:
\itemize{
\item Numerical instability in variance estimation
\item Incorrect weighting scheme application
\item Data processing errors
}
}
\note{
This function is primarily used for package development and validation.
End users typically don't need to call it directly.
}
\examples{
\donttest{
# After running df_counting
library(survival)
data(veteran)
veteran$treat <- as.numeric(veteran$trt) - 1

result <- df_counting(
  df = veteran,
  tte.name = "time",
  event.name = "status",
  treat.name = "treat"
)

# Check consistency of test statistics
check_results(result)

# Store results without printing
stats_comparison <- check_results(result, verbose = FALSE)
print(stats_comparison)
}

# Simple example with constructed data
dfcount_example <- list(
  lr = 2.5,
  sig2_lr = 1.0,
  z.score = 2.5,
  logrank_results = list(chisq = 6.25)
)
check_results(dfcount_example)

}
\seealso{
\code{\link{df_counting}} for generating the input object
}
\concept{diagnostic_functions}
