% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmplotting_helpers.R
\name{add_legends}
\alias{add_legends}
\title{Add legends to KM plot}
\usage{
add_legends(
  dfcount,
  show.cox,
  cox.cex,
  put.legend.cox,
  show.logrank,
  logrank.cex,
  put.legend.lr,
  show_arm_legend,
  arms,
  col.1,
  col.0,
  ltys,
  lwds,
  arm.cex,
  put.legend.arms
)
}
\arguments{
\item{dfcount}{List with results, typically output from a survival analysis function. Should contain elements such as \code{cox_results}, \code{z.score}, and \code{zlogrank_text}.}

\item{show.cox}{Logical; show Cox legend.}

\item{cox.cex}{Numeric; Cox legend size.}

\item{put.legend.cox}{Character; Cox legend position (e.g., "topright").}

\item{show.logrank}{Logical; show logrank legend.}

\item{logrank.cex}{Numeric; logrank legend size.}

\item{put.legend.lr}{Character; logrank legend position (e.g., "topleft").}

\item{show_arm_legend}{Logical; show arm legend.}

\item{arms}{Character vector of arm labels.}

\item{col.1}{Color for group 1.}

\item{col.0}{Color for group 0.}

\item{ltys}{Line types.}

\item{lwds}{Line widths.}

\item{arm.cex}{Numeric; arm legend size.}

\item{put.legend.arms}{Character; arm legend position (e.g., "left").}
}
\value{
Invisibly returns NULL. Used for plotting side effects.
}
\description{
Adds legends for Cox model, log-rank test, and arms to a Kaplan-Meier plot.
}
