% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVectorIndex.R
\name{getVectorIndex}
\alias{getVectorIndex}
\title{Calculate vector index}
\usage{
getVectorIndex(
  collections,
  pools,
  interval,
  target_disease,
  pt_estimate = "bc-mle",
  scale = 1000,
  agency = NULL,
  species = NULL,
  trap = NULL,
  sex = NULL,
  trapnight_min = 1,
  trapnight_max = NULL,
  separate_by = NULL
)
}
\arguments{
\item{collections}{Collections data retrieved from `getArthroCollections()`}

\item{pools}{Pools data retrieved from `getPools()`}

\item{interval}{Calculation interval for vector index, accepts "CollectionDate","Biweek","Week", and "Month}

\item{target_disease}{The disease to calculate infection rate for–i.e. "WNV". Disease acronyms are the accepted input. To see a list of disease acronyms, run `unique(pools$target_acronym)`}

\item{pt_estimate}{The estimation type for infection rate. Options include: "mle","bc-"mle", "mir"}

\item{scale}{Constant to multiply infection rate, default is 1000}

\item{agency}{Character vector for filtering agency by character code}

\item{species}{Character vector for filtering species. View species in your data `unique(data$species_display_name)`. Defaults to all species if no selection}

\item{trap}{Character vector for filtering trap type by acronym. View trap types in your data`unique(data$trap_acronym`. Defaults to all trap types}

\item{sex}{Character vector for filtering sex type. View sex options `unique(data$sex_type`). Defaults to "female".}

\item{trapnight_min}{Minimum trap night restriction for calculation. Default is 1.}

\item{trapnight_max}{Maximum trap night restriction for calculation. Default is no restriction.}

\item{separate_by}{Separate/group the calculation by 'trap','species' or 'agency'. Default NULL does not separate.}
}
\value{
Dataframe containing the vector index calculation
}
\description{
`getVectorIndex()` Calculates vector index from pools and collections data
}
\examples{
getVectorIndex(collections=sample_collections,
pools=sample_pools, interval="Month", target_disease = "WNV", pt_estimate="mle")
}
