% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{AirCrash}
\alias{AirCrash}
\title{Air Crash Data}
\format{
A data frame with 439 observations on the following 5 variables.
\describe{
\item{\code{Phase}}{phase of the flight, a factor with levels \verb{en route} \code{landing}
\code{standing} \code{take-off}
\code{unknown}}
\item{\code{Cause}}{a factor with levels \code{criminal} \verb{human error} \code{mechanical}
\code{unknown} \code{weather}}
\item{\code{date}}{date of crash, a Date}
\item{\code{Fatalities}}{number of fatalities, a numeric vector}
\item{\code{Year}}{year, a numeric vector}
}
}
\source{
Originally from David McCandless,
\url{https://informationisbeautiful.net/visualizations/plane-truth-every-single-commercial-plane-crash-visualized/},
with the data at
\url{https://docs.google.com/spreadsheets/d/1OvDq4_BtbR6nSnnHnjD5hVC3HQ-ulZPGbo0RDGbzM3Q/edit?usp=drive_web},
downloaded April 14, 2015.
}
\description{
Data on all fatal commercial airplane crashes from 1993--2015. Excludes
small planes (less than 6 passengers) and non-commercial (cargo, military,
private) aircraft.
}
\details{
\code{Phase} of the flight was cleaned by combining related variants,
spelling, etc.
}
\examples{

data(AirCrash)
aircrash.tab <- xtabs(~Phase + Cause, data=AirCrash)
mosaic(aircrash.tab, shade=TRUE)

# fix label overlap
mosaic(aircrash.tab, shade=TRUE,
       labeling_args=list(rot_labels=c(30, 30, 30, 30)))

# reorder by Phase
phase.ord <- rev(c(3,4,1,2,5))
mosaic(aircrash.tab[phase.ord,], shade=TRUE,
       labeling_args=list(rot_labels=c(30, 30, 30, 30)),
       offset_varnames=0.5)

# reorder by frequency
phase.ord <- order(rowSums(aircrash.tab), decreasing=TRUE)
cause.ord <- order(colSums(aircrash.tab), decreasing=TRUE)
mosaic(aircrash.tab[phase.ord,cause.ord], shade=TRUE,
       labeling_args=list(rot_labels=c(30, 30, 30, 30)))


library(ca)
aircrash.ca <- ca(aircrash.tab)
plot(aircrash.ca)

}
\references{
Rick Wicklin,
\url{http://blogs.sas.com/content/iml/2015/03/30/visualizing-airline-crashes.html}
}
\keyword{datasets}
